% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{renameRegions}
\alias{renameRegions}
\title{Rename regions.}
\usage{
renameRegions(SNPhood.o, newRegionsMapping, verbose = TRUE)
}
\arguments{
\item{SNPhood.o}{Object of class \code{\linkS4class{SNPhood}}}

\item{newRegionsMapping}{Named list. For clarity of mapping, the names of the list must be the currently defined region names, 
and the values of each element the corresponding new ones.}

\item{verbose}{Logical(1). Default TRUE. Should the verbose mode (i.e., diagnostic messages during execution of the script) be enabled?}
}
\value{
An object of class \code{\link{SNPhood}} with the requested regions being renamed
}
\description{
\code{renameRegions} renames regions from a \emph{SNPhood} object.
}
\examples{
data(SNPhood.o, package="SNPhood")
mapping = as.list(paste0(annotationRegions(SNPhood.o),".newName"))
names(mapping) = annotationRegions(SNPhood.o)
SNPhood_mod.o = renameRegions(SNPhood.o, mapping)
}
\seealso{
\code{\link{renameBins}}, \code{\link{renameDatasets}}, \code{\link{renameReadGroups}}
}

