% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize.R
\name{plotAllelicBiasResults}
\alias{plotAllelicBiasResults}
\title{Graphically summarize the results of the allelic bias analysis for a specific dataset and region.}
\usage{
plotAllelicBiasResults(SNPhood.o, dataset = 1, region = 1,
  signThreshold = 0.05, readGroupColors = NULL, fileToPlot = NULL,
  verbose = FALSE)
}
\arguments{
\item{SNPhood.o}{Object of class \code{\linkS4class{SNPhood}}}

\item{dataset}{Numeric(1) or Character(1). Single dataset that should be used for plotting, either specified as integer (such as 1, value must be
between 1 and the total number of datasets as defined in the object) or its annotation (name must appear in the dataset names as obtained via the function \code{annotationDatasets}).}

\item{region}{Numeric(1) or Character(1). Single region that should be plotted, either specified as integer (such as 1, value must be
between 1 and the total number of region as defined in the object) or its annotation (name must appear in the region names as obtained via the function \code{annotationRegions}).}

\item{signThreshold}{Numeric(1). Default 0.05. The significance threshold (such as p-value or FDR threshold). Must be between 0 and 1. If the parameter belongs to a plotting function, a horizontal line is drawn at the chosen value. For the allelic bias summary plots, p-values below this threshold and the corresponding allelic fractions are highlighted.}

\item{readGroupColors}{Character or NULL. Default NULL. Colors of the read groups that appear in the plot.
If set to NULL, colors will be set automatically. The length of the vector must equal the \strong{total} number of read groups 
that are defined in the \code{SNPhood} object.}

\item{fileToPlot}{Character(1) or \code{NULL}. Default \code{NULL}. 
Filename of the PDF file for the output plots.
If set to \code{NULL}, plots will be plotted to the currently active device.}

\item{verbose}{Logical(1). Default FALSE. Should the verbose mode (i.e., diagnostic messages during execution of the script) be enabled?}
}
\value{
the generated \pkg{ggplot2} plot(s) as list for further processing. May contain multiple plots, depending on the function. The plot(s) can then be plotted individually or modified arbitrarily as the user wants. For example, if multiple plots are returned and the plots have been saved in a variable called plots.l, simply type plots.l[[1]] to view the first plot.
}
\description{
\code{plotAllelicBiasResults} graphically summarizes the results of the allelic bias analysis for a specific dataset and region.
Three plots are generated, each of which focuses on a different aspect of the allelic bias analysis across the selected user region.
}
\details{
The first plot shows the estimates of the allelic fraction, along with confidence intervals for the estimate
according to the parameters chosen when the function \code{testForAllelicBias} was called. Fraction estimates for which the corresponding p-values
are deemed significant according to the value of the parameter \code{signThreshold} are highlighted (see also the legend). At 0.5, the estimated
allelic fraction if there was no allelic bias, a horizontal line is drawn.

The second plot shows the p-values (-log 10 transformed, so that smaller p-values have higher transformed values).
In analogy to the estimates of the allelic fraction, significant p-values are highlighted. The -log10 transformed significance threshold 
(according to the parameter \code{signThreshold}) appears as a horizontal line.

Finally, the third plot shows the distribution of the read counts across all read groups. In addition, the genotype distribution for each
read group is given (see the Vignette for details). This helps to identify allelic biases based on genotype differences among read groups.
}
\examples{
data(SNPhood.o, package="SNPhood")
SNPhood.o = testForAllelicBiases(SNPhood.o, readGroups = c("maternal", "paternal"))
# Leave all parameters with their standard values
plots = plotAllelicBiasResults(SNPhood.o)

# Change the colors
plots = plotAllelicBiasResults(SNPhood.o, readGroupColors = c("blue", "red", "gray"))

# Alter the significance threshold
plots = plotAllelicBiasResults(SNPhood.o, signThreshold = 0.01)

}

