% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPages.R
\name{getPages}
\alias{getPages}
\title{Download SNPedia pages}
\usage{
getPages(titles, verbose = FALSE, limit = 50,
  wikiParseFunction = identity, baseURL, format, query, ...)
}
\arguments{
\item{titles}{Titles of the pages to be downloaded.}

\item{verbose}{If TRUE some messages are provided.}

\item{limit}{The maximum number of items to be queried at a time.}

\item{wikiParseFunction}{Function to be used to parse the wiki code
at downloading time.
Default is \code{identity} so the raw wiki text is provided.}

\item{baseURL}{SNPedia boots URL.}

\item{format}{Downloading format. Currently just JSON is available.}

\item{query}{The query to be iterated.}

\item{\dots}{any parameter to be pasted to the \code{wikiParseFunction}.}
}
\value{
A list containing the wiki content of the required pages
or the formatted objects returned by the \code{wikiParseFunction}
applied to each page.
}
\description{
A function to download the (wiki) text content of a list of SNPedia pages.
}
\details{
JSON format is parsed to extract the wiki text returned by the function.

If the \code{wikiParseFunction} parameter is provided,
parsing of the pages is done internally once each batch of pages
is downloaded.

Pages do not need to be of the same class...
but users may be aware of the type of pages they are queering,
moreover when using their own \code{wikiParseFunction}.

Parameters \code{baseURL}, \code{format} and \code{query}
are not intended for end users.
}
\examples{
res <- getPages(titles = "Rs1234")
res

res <- getPages(titles = c("Rs1234", "Rs1234(A;A)", "Rs1234(A;C)"))
res

myfun <- function(x) substring(x, 1, 5)
lapply(res, myfun)

res <- getPages(titles = c("Rs1234", "Rs1234(A;A)", "Rs1234(A;C)"),
wikiParseFunction = myfun)
res

}
\seealso{
extractTags, getCategoryElements
}
