% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/siamcat_class_accessors.R
\docType{methods}
\name{label}
\alias{label}
\alias{label,siamcat-method}
\title{Retrieve the label from a SIAMCAT object}
\usage{
label(siamcat, verbose=1)

\S4method{label}{siamcat}(siamcat, verbose = 1)
}
\arguments{
\item{siamcat}{(Required). A \link{siamcat-class} object}

\item{verbose}{integer, if the slot is empty, should a message be printed?
values can be either \code{0} (no output) or \code{1} (print message)}
}
\value{
The label or NULL.
}
\description{
Retrieve the label from a SIAMCAT object
}
\details{
This function will retrieve the label information from a
SIAMCAT object. The label will contain three entries: \itemize{
\item \code{label}: The label as named vector, in which the classes are
encoded numerically
\item \code{info}: Information about the different classes
\item \code{type}: What kind of label is it?
}
}
\examples{
data(siamcat_example)
temp <- label(siamcat_example)
head(temp$label)
temp$info
temp$type
}
