% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/counts.R
\name{getSGFeatureCountsPerSample}
\alias{getSGFeatureCountsPerSample}
\title{Compatible fragment counts for splice graph features}
\usage{
getSGFeatureCountsPerSample(features, file_bam, paired_end, sample_name,
  min_anchor, retain_coverage, verbose, cores)
}
\arguments{
\item{features}{\code{SGFeatures} object}

\item{file_bam}{BAM file with genomic RNA-seq read alignments}

\item{paired_end}{Logical, \code{TRUE} for paired-end data,
\code{FALSE} for single-end data}

\item{sample_name}{Sample name used in messages}

\item{min_anchor}{Integer specifiying minimum anchor length}

\item{retain_coverage}{Logical indicating whether coverage for each
exon should be retained as an \code{RleList} in metadata
column \dQuote{coverage}. This allows filtering of features
using more stringent criteria after the initial prediction.}

\item{verbose}{If \code{TRUE}, generate messages indicating progress}

\item{cores}{Number of cores available for parallel processing}
}
\value{
Numeric vector of compatible fragment counts
}
\description{
Obtain counts of compatible fragments for splice graph features.
}
\author{
Leonard Goldstein
}
\keyword{internal}
