% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normWrapper.R
\name{normWrapper}
\alias{normWrapper}
\title{Iteratively fit group regression and evaluate to choose optimal K}
\usage{
normWrapper(
  Data,
  SeqDepth = NULL,
  Slopes = NULL,
  CondNum = NULL,
  PrintProgressPlots,
  PropToUse,
  Tau,
  Thresh,
  ditherCounts
)
}
\arguments{
\item{Data}{can be a matrix of single-cell expression with cells
where rows are genes and columns are samples. Gene names should
not be a column in this matrix, but should be assigned to rownames(Data).
Data can also be an object of class \code{SummarizedExperiment} that contains 
the single-cell expression matrix and other metadata. The \code{assays} 
slot contains the expression matrix and is named \code{"Counts"}.  
This matrix should have one row for each gene and one sample for each column.  
The \code{colData} slot should contain a data.frame with one row per 
sample and columns that contain metadata for each sample.  This data.frame
should contain a variable that represents biological condition 
in the same order as the columns of \code{NormCounts}). 
Additional information about the experiment can be contained in the
\code{metadata} slot as a list.}

\item{SeqDepth}{sequencing depth for each cell/sample.}

\item{Slopes}{per gene estimates of the count-depth relationship.}

\item{CondNum}{name of group being normalized, just for printing messages.}

\item{PrintProgressPlots}{whether to automatically produce plot as SCnorm 
determines the optimal number of groups (default is FALSE, highly 
suggest using TRUE). Plots will be printed to the current device.}

\item{PropToUse}{proportion of genes closest to the slope mode used for
the group fitting, default is set at .25. This number #' mainly affects
speed.}

\item{Tau}{value of quantile for the quantile regression used to estimate
gene-specific slopes (default is median, Tau = .5 ).}

\item{Thresh}{threshold to use in evaluating the sufficiency of K, default
is .1.}

\item{ditherCounts}{whether to dither/jitter the counts, may be used for
data with many ties, default is FALSE.}
}
\value{
matrix of normalized and scaled expression values for all conditions
   and the evaluation plots are 
output for each attempted value of K.
}
\description{
This function iteratively normalizes using K groups and then
   evaluates whether K is sufficient. If the maximum mode received 
from the GetK() function is larger than .1, K is increased to K + 1. Uses
   params sent from SCnorm.
}
\author{
Rhonda Bacher
}
