% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segment_CBScs.R
\name{segment_CBScs}
\alias{segment_CBScs}
\title{Cross-sample segmentation}
\usage{
segment_CBScs(Y, Yhat, sampname, ref, chr, 
                    mode = "integer", max.ns)
}
\arguments{
\item{Y}{raw read depth matrix after quality control procedure}

\item{Yhat}{normalized read depth matrix}

\item{sampname}{vector of sample names}

\item{ref}{GRanges object after quality control procedure}

\item{chr}{chromosome name. Make sure it is consistent with the
reference genome.}

\item{mode}{format of returned copy numbers. Only integer mode is
supported for scDNA-seq data.}

\item{max.ns}{a number specifying how many rounds of nested structure
searching would be performed. Defalut is \code{0}.}
}
\value{
A list with components
    \item{poolcall}{Cross-sample CNV callings indicating
        shared breakpoints}
    \item{finalcall}{Final cross-sample segmented callset of
        CNVs with genotyping results}
    \item{image.orig}{A matrix giving logarithm of normalized
        z-scores}
    \item{image.seg}{A matrix of logarithm of estimated
        copy number over 2}
    \item{iCN}{A matrix of inferred integer copy number profiles}
}
\description{
SCOPE offers a cross-sample Poisson likelihood-based
recursive segmentation, enabling shared breakpoints across cells
from the same genetic background.
}
\examples{
Yhat.sim <- normObj.scopeDemo$Yhat[[which.max(normObj.scopeDemo$BIC)]]
segment_cs_chr1 <- segment_CBScs(Y = Y_sim, Yhat = Yhat.sim,
                        sampname = colnames(Y_sim),
                        ref = ref_sim, chr = 'chr1', max.ns = 1)

}
\author{
Rujin Wang \email{rujin@email.unc.edu}
}
