% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initialize_ploidy.R
\name{initialize_ploidy}
\alias{initialize_ploidy}
\title{Ploidy pre-initialization}
\usage{
initialize_ploidy(Y, Yhat, ref, maxPloidy = 6, minPloidy = 1.5,
                minBinWidth = 5, SoS.plot = FALSE)
}
\arguments{
\item{Y}{raw read depth matrix after quality control procedure}

\item{Yhat}{normalized read depth matrix}

\item{ref}{GRanges object after quality control procedure}

\item{maxPloidy}{maximum ploidy candidate. Defalut is \code{6}}

\item{minPloidy}{minimum ploidy candidate. Defalut is \code{1.5}}

\item{minBinWidth}{the minimum number of bins for a changed segment.
Defalut is \code{5}}

\item{SoS.plot}{logical, whether to generate ploidy pre-estimation 
plots. Default is \code{FALSE}.}
}
\value{
\item{ploidy.SoS}{Vector of pre-estimated ploidies for each cell}
}
\description{
Pre-estimate ploidies across all cells
}
\examples{
Gini <- get_gini(Y_sim)

# first-pass CODEX2 run with no latent factors
normObj.sim <- normalize_codex2_ns_noK(Y_qc = Y_sim,
                                        gc_qc = ref_sim$gc,
                                        norm_index = which(Gini<=0.12))
Yhat.noK.sim <- normObj.sim$Yhat
beta.hat.noK.sim <- normObj.sim$beta.hat
fGC.hat.noK.sim <- normObj.sim$fGC.hat
N.sim <- normObj.sim$N

# Ploidy initialization
ploidy.sim <- initialize_ploidy(Y = Y_sim, 
                                Yhat = Yhat.noK.sim, 
                                ref = ref_sim)
ploidy.sim

}
\author{
Rujin Wang \email{rujin@email.unc.edu}
}
