% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ShinyFunctions.R
\name{reindex_clusters}
\alias{reindex_clusters}
\title{Reindex cluster labels in ascending order}
\usage{
reindex_clusters(hc, k)
}
\arguments{
\item{hc}{an object of class hclust}

\item{k}{number of cluster to be inferred from hc}
}
\description{
Given an \code{\link[stats]{hclust}} object and the number of clusters \code{k}
this function reindex the clusters inferred by \code{cutree(hc, k)[hc$order]}, so that
they appear in ascending order. This is particularly useful when plotting
heatmaps in which the clusters should be numbered from left to right.
}
\examples{
hc <- hclust(dist(USArrests), 'ave')
cutree(hc, 10)[hc$order]
reindex_clusters(hc, 10)[hc$order]

}
