% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.utilities.R
\docType{class}
\name{spline.arc-class}
\alias{spline.arc-class}
\title{An object to store information of spline arcs}
\description{
An object to store information of spline arcs
}
\details{
Arc information comes from two sources:1. SBGN-ML file's 'arc' element ('source', 'target', coordinates etc.). 2. Parameters specified when running \code{\link{SBGNview}}.  User can modify arc objects to change the way how they are rendered. See the "arcs.user" argument in \code{\link{renderSbgn}}.
}
\section{Slots}{

\describe{
\item{\code{target,source,id,arc.class}}{A character string. Information extracted from element 'arc.spline'.}

\item{\code{start.x,start.y,end.x,end.y}}{Numeric. Information extracted from elements 'start', 'end' or 'next'.}

\item{\code{stroke.opacity}}{Numeric. Controls the line of an arc (not tip of arc).}

\item{\code{components}}{A list of 'arc' and 'spline' objects. A spline arc is represented by several components: 1. The two ends of the arc are represented by straight line 'arc' objects. 2. splines connecting the ends are represented by 'spline' objects.}

\item{\code{parameters.list}}{A list. The parameters.list slot is a copy of the global.parameters.list. The global.parameters.list contains the '...' parameters passed into \code{\link{SBGNview}} which will be used by \code{\link{renderSbgn}}. By default this slot for all spline.arc objects in the output SBGNview object will be an empty list. You can add named elements to this slot to customize each individual spline.arc. For information about which parameters can be set in the parameters.list slot, see the arguments in \code{\link{renderSbgn}}. A customized list of arc objects can be passed as input into SBGNview function using the ‘arcs.user’ argument (see \code{\link{renderSbgn}} for more information).}

\item{\code{edge}}{A list. An arc in SBGN map normally consists of a line and a tip shape at the end of the line. This list holds variables that controls arc properties. Available elements can be accessed as follow:

         The following three parameters control the line:\cr
            arc@edge$line.stroke.color\cr
            arc@edge$line.stroke.opacity\cr
            arc@edge$line.width\cr
                    
         The following five parameters control the tip:\cr
            arc@edge$tip.stroke.opacity\cr
            arc@edge$tip.stroke.color\cr
            arc@edge$tip.stroke.width\cr
            arc@edge$tip.fill.color\cr
            arc@edge$tip.fill.opacity\cr}
}}

