% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SBGN.to.SVG.R
\name{renderSbgn}
\alias{renderSbgn}
\title{Overlay omics data on a SBGN pathway graph and output image files.}
\usage{
renderSbgn(
  input.sbgn,
  output.file,
  output.formats,
  sbgn.id.attr,
  glyphs.user = list(),
  arcs.user = list(),
  arcs.info = "straight",
  compartment.layer.info = "original",
  user.data = matrix("no.user.data", nrow = 1),
  if.plot.svg = TRUE,
  key.pos = "topright",
  color.panel.scale = 1,
  color.panel.n.grid = 21,
  col.gene.low = "green",
  col.gene.high = "red",
  col.gene.mid = "gray",
  col.cpd.low = "blue",
  col.cpd.high = "yellow",
  col.cpd.mid = "gray",
  min.gene.value = -1,
  max.gene.value = 1,
  mid.gene.value = 0,
  min.cpd.value = -1,
  max.cpd.value = 1,
  mid.cpd.value = 0,
  pathway.name = "",
  pathway.name.font.size = 1,
  if.plot.cardinality = FALSE,
  multimer.margin = 5,
  compartment.opacity = 1,
  auxiliary.opacity = 1,
  if.plot.annotation.nodes = FALSE,
  inhibition.edge.end.shift = 5,
  edge.tip.size = 6,
  if.use.number.for.long.label = FALSE,
  label.spliting.string = c(" ", ":", "-", ";", "/", "_"),
  complex.compartment.label.margin = 8,
  if.write.shorter.label.mapping = TRUE,
  font.size = 3,
  logic.node.font.scale = 3,
  status.node.font.scale = 3,
  node.width.adjust.factor = 2,
  font.size.scale.gene = 3,
  font.size.scale.cpd = 3,
  font.size.scale.complex = 1.1,
  font.size.scale.compartment = 1.6,
  if.scale.complex.font.size = FALSE,
  if.scale.compartment.font.size = FALSE,
  node.width.adjust.factor.compartment = 0.02,
  node.width.adjust.factor.complex = 0.02,
  text.length.factor = 2,
  text.length.factor.macromolecule = 2,
  text.length.factor.compartment = 2,
  text.length.factor.complex = 2,
  space.between.color.panel.and.entity = 100,
  global.parameters.list = NULL
)
}
\arguments{
\item{input.sbgn}{A character string. The path to a local SBGN-ML file.}

\item{output.file, output.formats, sbgn.id.attr}{These parameters are the same as the ones in \code{\link{SBGNview}}. Please see \code{\link{SBGNview}} for more details.}

\item{glyphs.user}{A list, optional. Each element is a 'glyph' object. The element names are glyph IDs (attribute 'id' of XHTML element 'glyph'). Note this is not affected by parameter 'sbgn.id.attr'. The glyph elements contain glyph meta-data for plotting (e.g. text size, border width, border color etc.). Please see the \code{\link{glyph-class}} documentation for more information. By default, SBGNview will run without this argument and return a glyph list extracted from the SBGN file. User can then customize this glyph list and assign it to 'glyphs.user' in the next SBGNview run to update the graph.}

\item{arcs.user}{A list, optional. Each member is an 'arc' object. The element names are arc IDs (the value of 'id' attribute in XHTML element 'arc' or 'arc.spline' in the SBGN-ML file). Some SBGN-ML files have no arc IDs, in this case SBGNview  will create an arc ID using 'source' and 'target' node IDs). The arc object contains arc meta-data for plotting (e.g. arc line width, line color etc.). Please see the \code{\link{arc-class}} documentation for more information. By default, SBGNview() will run without this argument and return an arc list. User can then customize this arc list and assign it to 'arcs.user' in the next SBGNview() run to update the arcs.}

\item{arcs.info}{A character string. It should be one of the following: 'parse splines', 'straight' or a string of svg code of arcs. If it is 'parse splines', this function will look for XML element 'arc.spline' in the SBGN-ML file and plot spline arcs. If it is 'straight', the function will look for element 'arc' and plot straight line arcs. If it is a string of svg code, it will write this code directly to the output svg file.}

\item{compartment.layer.info}{A character vector. It is a vector containing the IDs of all compartment glyphs. It determins the layer arrangement of compartments. Compartments will be drawn following their sequence in this vector. Therefore, a compartment that appears later in the vector will be on the front layer and covers the compartments that are before it in this vector. This is important. In some cases compartments have overlap. This layer information ensures that a glyph laying in the overlapped region belongs to the compartment on the top layer.}

\item{user.data}{A list. It holds both gene/protein data and compound data. Names are gene or compounds, each element is a numeric vector of the omics data of each molecule.}

\item{if.plot.svg}{Logical. Default: T. Whether to generate svg code or only parse SBGN-ML file. This parameter is for internal use only.}

\item{key.pos}{A character string. The position of color panel. Default: 'topright'. Accepts one of 'bottomleft' , 'bottomright', 'topright', or 'topleft'. The ideal position for the color panel is 'topright' or 'bottomright'. If 'topleft' or 'bottomleft' are passed in, the key.pos location will default to 'topright'. If key.pos is set to 'none', the pathway name and color panel won't be plotted.}

\item{color.panel.scale}{Numeric. Default: 1. It controls the relative size of color scheme panel.}

\item{color.panel.n.grid}{Numeric. Default: 21. How many colors does the color scheme show.}

\item{col.gene.low}{A character string. Default: 'green'. Color panel's color representing low gene data values.}

\item{col.gene.high}{A character string. Default: 'red'. Color panel's color representing high gene data values.}

\item{col.gene.mid}{A character string. Default: 'gray'. Color panel's color representing mid range gene data values.}

\item{col.cpd.low}{A character string. Default: 'blue'. Color panel's color representing low compound data values.}

\item{col.cpd.high}{A character string. Default: 'yellow'. Color panel's color representing high compound data values.}

\item{col.cpd.mid}{A character string. Default: 'gray'. Color panel's color representing mid range compound data values.}

\item{min.gene.value}{Numeric. Default: -1. Color panel's min value for gene data. Values smaller than this will have the same color as min value.}

\item{max.gene.value}{Numeric. Default: 1. Color panel's max value for gene data. Values greater than this will have the same color as the max value.}

\item{mid.gene.value}{Numeric. Default: 0. Color panel's mid value for gene data.}

\item{min.cpd.value}{Numeric. Default: -1. Color panel's min value for compound data. Values smaller than this will have the same color as min value.}

\item{max.cpd.value}{Numeric. Default: 1. Color panel's max value for compound data. Values greater than this will have the same color as max value.}

\item{mid.cpd.value}{Numeric. Default: 0. Color panel's mid value for compound data.}

\item{pathway.name}{List containing two elements: 1. pathway name 2. stamp information. See argument description in \code{\link{SBGNview}} function to change/update pathway name displayed on graph.}

\item{pathway.name.font.size}{Numeric. Default: 1. When pathway names are plotted on graph, this parameter controls their font size.}

\item{if.plot.cardinality}{Logical. Default: F. If plot cardinality glyphs.}

\item{multimer.margin}{Numeric. Default: 5. For multimers, they are represented by two partly overlapped shapes (rectangle, ellipse etc.). This parameter controls how much the two shapes overlap.}

\item{compartment.opacity}{Numeric. Default: 1. Controls how transparent the compartments are.}

\item{auxiliary.opacity}{Numeric. Default: 1.  Controls opacity of auxiliary glyphs.}

\item{if.plot.annotation.nodes}{Logical. Default: F. Some SBGN-ML files have 'annotation' glyphs. By default we don't plot them.}

\item{inhibition.edge.end.shift}{Numeric. Default: 5. The tip of 'inhibition' arcs is a line segment. Sometimes it overlaps with target glyph's border. We can shift it along the arc to prevent the overlap.}

\item{edge.tip.size}{Numeric. Default: 6. Control size of edge tips.}

\item{if.use.number.for.long.label}{Logical. Default: F. If the label is too long, we can create a shorter name for it. e.g. 'macromolecule_1'.}

\item{label.spliting.string}{A character vector. Default: c(' ','-',';','/','_'). When we split text into multiple lines, these characters will be used to split label (where a new line can be created).}

\item{complex.compartment.label.margin}{Numeric. Default: 8. Move the label text vertically for compartment and complex.}

\item{if.write.shorter.label.mapping}{Logical. Default: T. If if.use.number.for.long.label is 'T', we can write the mapping between shorter name and the original label to a text file.}

\item{font.size}{Numeric. Default: 3. Affects font size of all types of glyphs.}

\item{logic.node.font.scale}{Numeric. Default: 3. Controls the size of logical glyphs ('and', 'or', 'not' etc.).}

\item{status.node.font.scale}{Numeric. Default: 3. Scale the font size for status variable and unit of information nodes.}

\item{node.width.adjust.factor}{Numeric. Default: 2. Change font size according to the width of its glyph. If the glyph is too large (e.g. compartment), its label may look too small. Then we can enlarge the label in proportion to the width of the glyph. It affects all types of glyphs.}

\item{font.size.scale.gene}{Numeric. Default: 3. Scales font size according to the node's width for large compartments. Only affect font size of 'macromolecule' glyphs.}

\item{font.size.scale.cpd}{Numeric. Default: 3. Scales font size according to the node's width for large compartments. Only affects font size of 'simple chemical' glyphs.}

\item{font.size.scale.complex}{Numeric. Default: 1.1. Scale the font size of a complex.}

\item{font.size.scale.compartment}{Numeric. Default: 1.6. Scale the font size of a compartment.}

\item{if.scale.complex.font.size}{Logical. Default: F.  Whether to scale complex font size according to its width. If set to 'T', the 'node.width.adjust.factor.complex' argument can be used to specify the scale factor.}

\item{if.scale.compartment.font.size}{Logical. Default: F. Whether to scale compartment font size according to its width. If set to 'T', the 'node.width.adjust.factor.compartment' argument can be used to specify the scale factor.}

\item{node.width.adjust.factor.compartment}{Numeric. Default: 0.02. How much the font size should change in proportion to the width of compartment. The font is scaled only if 'if.scale.compartment.font.size' is set to 'T'. To find the best scale factor which works you, start with 0.02 (default) and incrementally increase that value.}

\item{node.width.adjust.factor.complex}{Numeric. Default: 0.02. How much the font size should change in proportion to the width of complex. The font is scaled only if 'if.scale.complex.font.size' is set to 'T'. To find the best scale factor which works you, start with 0.02 (default) and incrementally increase that value.}

\item{text.length.factor}{Numeric. Default: 2. How wide the wrapped text should be. If text is longer than the width controled by this parameter, the text is split into a new line, but only at characters in 'label.spliting.string'. Controls all glyphs.}

\item{text.length.factor.macromolecule}{Numeric. Default: 2. Used to determine label text wrapping based on number of characters, font size, and node width for macromolecule glyphs.}

\item{text.length.factor.compartment}{Numeric. Default: 2. Used to determine label text wrapping based on number of characters, font size, and node width for compartment glyphs.}

\item{text.length.factor.complex}{Numeric. Default: 2. Used to determine label text wrapping based on number of characters, font size, and node width for complex glyphs.}

\item{space.between.color.panel.and.entity}{Numeric. Default: 100. The minimum space between color panel and any other object in the graph. The function will always try to find a location of the color panel to minimize empty space on the whole graph. This parameter controls how close it can reach a glyph.}

\item{global.parameters.list}{List. A record of parameters fed to 'renderSbgn' for reuse. It will over-write other parameters. It is not designed to be used directly.}
}
\value{
A list of three elements: glyphs.list, arcs.list, global.parameters.list
}
\description{
This function is not intended to be used directly. Use SBGNview instead. Some input arguments can be better prepared by \code{\link{SBGNview}}.
}
\examples{
\dontrun{
data(pathways.info)
SBGNview.obj <- SBGNview(simulate.data = TRUE,
                         sbgn.dir = './',
                         input.sbgn = 'P00001',
                         output.file = './test.local.file',
                         output.formats = c('pdf'),
                         min.gene.value = -1,
                         max.gene.value = 1)
 }

}
