% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download.utilities.R
\name{loadMappingTable}
\alias{loadMappingTable}
\title{Generate ID mapping table from input and output ID types}
\usage{
loadMappingTable(
  input.type = NULL,
  output.type = NULL,
  species = NULL,
  mol.type = NULL,
  limit.to.ids = NULL,
  SBGNview.data.folder = "./SBGNview.tmp.data"
)
}
\arguments{
\item{input.type}{A character string. Gene or compound ID type}

\item{output.type}{A character string. Gene or compound ID type}

\item{species}{A character string. Three letter KEGG species code.}

\item{mol.type}{A character string. Either 'gene' or 'cpd'.}

\item{limit.to.ids}{Vector. Molecule IDs of 'input.type'.}

\item{SBGNview.data.folder}{A character string. Default: "./SBGNview.tmp.data". The path to a folder that will hold downloaded ID mapping files and pathway information data files.}
}
\value{
A list containing the mapping table.
}
\description{
This function generates the ID mapping table between input and output ID types. If provided a vector of input IDs (limit.to.ids argument), the function will output mapping table only containing the input IDs. Otherwise, the function will output all IDs of input and output types (restricted to a species if working on gene types and specified  the 'species' parameter).
This function will check if a mapping table exists in local folder ('SBGNview.data.folder' argument), SBGNview.data package, and SBGNhub. If no mapping table is found in these locations, a mapping table is generated using Pathview and saved to path specified by 'SBGNview.data.folder' argument.
}
\examples{
 data(mapped.ids)
 entrez.to.pathwayCommons <- loadMappingTable(input.type = 'ENTREZID',
                                              output.type = 'pathwayCommons',
                                              species = 'hsa',
                                              mol.type = 'gene')
                             
}
