% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapping.utilities.R
\name{changeIds}
\alias{changeIds}
\title{Change vector of input IDs to another ID type}
\usage{
changeIds(
  input.ids = NULL,
  input.type = NULL,
  output.type = NULL,
  mol.type = NULL,
  limit.to.pathways = NULL,
  org = "hsa",
  SBGNview.data.folder = "./SBGNview.tmp.data"
)
}
\arguments{
\item{input.ids}{A vector of character strings. Input IDs that need to be converted.}

\item{input.type}{A character string. The type of input IDs. Supported ID types can be found in data(mapped.ids)}

\item{output.type}{A character string. The type of output IDs. Supported ID types can be found in data(mapped.ids)}

\item{mol.type}{A character string. One of 'gene' or 'cpd'.}

\item{limit.to.pathways}{A vector of character strings. A vector of pathways IDs. When 'output.type' is one of 'pathwayCommons' or 'metacyc.SBGN', one input ID (e.g. gene symbol) can map to multiple nodes in different pathways (SBGN-ML files). In this case, we can limit output to the specified pathways. When 'output.type' is NOT one of 'pathwayCommons' or 'metacyc.SBGN', this argument is ignored.}

\item{org}{A character string. Default: "hsa". Three letter KEGG species code.}

\item{SBGNview.data.folder}{A character string. Default: "./SBGNview.tmp.data". The path to a folder that will hold downloaded ID mapping files and pathway information data files.}
}
\value{
A list. Each element is the IDs in output.type that are mapped to one input ID.
}
\description{
This function changes a vector of input IDs to another ID type. It returns a list where each element is the input ID type is mapped to the output ID type. Please note that not every input ID might be mapped to the output type. To change the input IDs to another ID type for a data matrix, use the \code{\link{changeDataId}} function.
}
\examples{
data(mapped.ids)
mapping <- changeIds(input.ids = c(10327, 6652),
                     input.type = 'ENTREZID',
                     output.type = 'pathwayCommons',
                     mol.type = 'gene',
                     org = "hsa")

}
