% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tpcaResult-class.R
\docType{class}
\name{tpcaResult-class}
\alias{tpcaResult-class}
\alias{tpcaResult}
\title{S4 TPCA Result Class}
\value{
an object of class tpcaResult
with the following slots:
1) ObjList: containing the supplied list of
objects (e.g. a list of Expression Sets 
summarizing a TPP experiment)
2) ContrastList: containing the supplied list 
of constrast objects (if supplied for
performance of a differential Rtpca analysis)
3) CtrlCondName: character string indicating
the control condition, e.g. "control"
4) ContrastCondName: character string indicating
the contrast condition, e.g. "drug treatment"
5) DistMat: a matrix containing all pairwise
protein-protein distances obtained from comparing
their melting curves in the control condition
6) ContrastDistMat: a matrix containing all pairwise
protein-protein distances obtained from comparing
their melting curves in the contrast condition
7) CommonFeatures: a vector containing the features
(proteins) found in common between control and 
contrast condition
8) ComplexAnnotation: a data frame supplied by the
user annotating protein to protein complexes
9) ComplexBackgroundDistributionList: a list of 
distances drawn for random groups of proteins
with different number of members
10) PPiAnnotation: a data frame supplied by the
user annotating protein-protein interactions
11) PPiRocTable: data frame containing false positive
rate and true positive rate based on ranking the TPCA
analysis results by euclidean distance of melting curves
of protein pairs, annotated PPIs are considered true 
positives
12) PPiRocTableAnno: annotation to PPiRocTable
13) ComplexRocTable: data frame containing false positive
rate and true positive rate based on ranking the TPCA
analysis results by euclidean distance of melting curves
of proteins within annotated complexes, annotated complexes
are considered true positives, proteins in randomly permuted 
complex annotations are considered false positives
14) summaryMethod: character string of summarization method
used to summarize data across replicates
15) distMethod: character string of distance method
used to compare melting curves of proteins
16) tpcaResultTable: data frame containing the results
from a tpca analysis
17) diffTpcaResultTable: data frame containing the results
from a differential tpca analysis
}
\description{
S4 TPCA Result Class
}
\section{Slots}{

\describe{
\item{\code{ObjList}}{list.}

\item{\code{ContrastList}}{list.}

\item{\code{CtrlCondName}}{character.}

\item{\code{ContrastCondName}}{character.}

\item{\code{DistMat}}{matrix.}

\item{\code{ContrastDistMat}}{matrix}

\item{\code{CommonFeatures}}{vector.}

\item{\code{ComplexAnnotation}}{data.frame.}

\item{\code{ComplexBackgroundDistributionList}}{list.}

\item{\code{PPiAnnotation}}{data.frame.}

\item{\code{PPiRocTable}}{data.frame}

\item{\code{PPiRocTableAnno}}{data.frame}

\item{\code{ComplexRocTable}}{data.frame}

\item{\code{summaryMethod}}{character.}

\item{\code{distMethod}}{character.}

\item{\code{tpcaResultTable}}{data.frame.}

\item{\code{diffTpcaResultTable}}{data.frame.}
}}

\examples{
m1 <- matrix(1:12, ncol = 4)
m2 <- matrix(2:13, ncol = 4)
m3 <- matrix(c(2:10, 1:7), ncol = 4)

rownames(m1) <- 1:3
rownames(m2) <- 2:4
rownames(m3) <- 2:5

mat_list <- list(
    m1, m2, m3
)
tpcaObj <- new("tpcaResult", ObjList = mat_list)
}
