% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rqcCycleBaseCallsCalc.R,
%   R/rqcCycleBaseCallsLinePlot.R, R/rqcCycleBaseCallsPlot.R
\name{rqcCycleBaseCallsCalc}
\alias{rqcCycleBaseCallsCalc}
\alias{rqcCycleBaseCallsLinePlot}
\alias{rqcCycleBaseCallsPlot}
\title{Per cycle base calls plot}
\usage{
rqcCycleBaseCallsCalc(rqcResultSet)

rqcCycleBaseCallsLinePlot(rqcResultSet)

rqcCycleBaseCallsPlot(rqcResultSet)
}
\arguments{
\item{rqcResultSet}{list of \code{RqcResultSet} objects created by
\code{\link{rqc}} and \code{\link{rqcQA}} functions.}
}
\value{
Plot object from \code{\link{ggplot}} function.
}
\description{
Creates a bar graph of per cycle base calls.
}
\section{Functions}{
\itemize{
\item \code{rqcCycleBaseCallsCalc}: calculates necessary statistics

\item \code{rqcCycleBaseCallsLinePlot}: creates a line graph
}}

\examples{

checkpoint("Rqc", path=system.file(package="Rqc", "extdata"), {
  folder <- system.file(package="ShortRead", "extdata/E-MTAB-1147")
  files <- list.files(full.names=TRUE, path=folder)
  rqcResultSet <- rqcQA(files, pair=c(1,1), workers=1)
}, keep="rqcResultSet")
rqcCycleBaseCallsPlot(rqcResultSet)

}
\author{
Welliton Souza
}
\keyword{graphics}
\keyword{qc}
