% Generated by roxygen2 (4.0.1): do not edit by hand
\docType{methods}
\name{topData}
\alias{topData}
\alias{topData,Rnits-method}
\alias{topData,character,ANY-method}
\title{Data of top genes/probes}
\usage{
topData(object, id = NULL, fdr = NULL, top = 16, sort.by = "p-value")

\S4method{topData}{Rnits}(object, id = NULL, fdr = NULL, top = 16,
  sort.by = "p-value")
}
\arguments{
\item{object}{\code{\linkS4class{Rnits}} object on which \code{fit} has been applied}

\item{id}{Names of probes or genes}

\item{top}{Display results for top N genes/probes. Default \code{50}}

\item{fdr}{Display results for genes/probes less than FDR cutoff (if provided). Overrides \code{top} argument}

\item{sort.by}{Sort top results by either \code{p-value} or \code{FDR}}
}
\value{
A table of expression values of top genes/profiles
}
\description{
Extract expression data for top genes/probes
}
\examples{
# load pre-compiled expressionSet object for Ronen and Botstein yeast  chemostat data
data(yeastchemostat)
rnitsobj = build.Rnits(yeastchemostat, logscale = TRUE, normmethod = 'Between')
\dontrun{
# Fit model using gene-level summarization
rnitsobj <- fit(rnitsobj, gene.level = TRUE, clusterallsamples = FALSE)

#Get data for top genes
td <- topData(rnitsobj, FDR = 5)

}
}

