% Generated by roxygen2 (4.0.1): do not edit by hand
\docType{methods}
\name{summarizeProbes}
\alias{summarizeProbes}
\alias{summarizeProbes,Rnits-method}
\alias{summarizeProbes,character,ANY-method}
\title{Summarize probe level data to gene level data}
\usage{
summarizeProbes(object)

\S4method{summarizeProbes}{Rnits}(object)
}
\arguments{
\item{object}{\code{\linkS4class{Rnits}} object}
}
\value{
An object of class \code{\linkS4class{Rnits}} with gene level log ratios, which can be retrieved by \code{getLR(object)}
}
\description{
The code utilizes the probe-gene mapping from features file to summarize probe-level log ratios to gene level ratios.
}
\details{
Tukey's biweight is used to compute gene level summary
}
\examples{
# load pre-compiled expressionSet object for Ronen and Botstein yeast  chemostat data
data(yeastchemostat)
rnitsobj = build.Rnits(yeastchemostat, logscale = TRUE, normmethod = 'Between')
\donttest{
# Summarize gene-level data
rnitsobj <- summarizeProbes(rnitsobj)
}
}

