% Generated by roxygen2 (4.0.1): do not edit by hand
\docType{methods}
\name{getStat}
\alias{getStat}
\alias{getStat,Rnits-method}
\alias{getStat,character,ANY-method}
\title{Retrieve ratio statistics}
\usage{
getStat(object)

\S4method{getStat}{Rnits}(object)
}
\arguments{
\item{object}{\code{\linkS4class{Rnits}} object}
}
\value{
An vector of ratio statistics
}
\description{
Extract ratio statistics from fitted \code{\linkS4class{Rnits}} object
}
\examples{
# load pre-compiled expressionSet object for Ronen and Botstein yeast  chemostat data
data(yeastchemostat)
rnitsobj = build.Rnits(yeastchemostat, logscale = TRUE, normmethod = 'Between')
\dontrun{
# Fit model using gene-level summarization
rnitsobj <- fit(rnitsobj, gene.level = TRUE, clusterallsamples = FALSE)

# Get ratio statistics from fitted model
stat <- getStat(rnitsobj)
}
}

