% Generated by roxygen2 (4.0.1): do not edit by hand
\docType{methods}
\name{getPval}
\alias{getPval}
\alias{getPval,Rnits-method}
\alias{getPval,character,ANY-method}
\title{Get p-values}
\usage{
getPval(object)

\S4method{getPval}{Rnits}(object)
}
\arguments{
\item{object}{\code{\linkS4class{Rnits}} object}
}
\value{
An vector of p-values
}
\description{
Extract p-values from fitted \code{\linkS4class{Rnits}} object
}
\examples{
# load pre-compiled expressionSet object for Ronen and Botstein yeast  chemostat data
data(yeastchemostat)
rnitsobj = build.Rnits(yeastchemostat, logscale = TRUE, normmethod = 'Between')
\dontrun{
# Fit model using gene-level summarization
rnitsobj <- fit(rnitsobj, gene.level = TRUE, clusterallsamples = FALSE)

#Get pvalues from fitted model
pval <- getPval(rnitsobj)

}
}

