% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/profiles.R
\name{rnb.step.betadistribution}
\alias{rnb.step.betadistribution}
\title{rnb.step.betadistribution}
\usage{
rnb.step.betadistribution(
  rnb.set,
  report,
  columns = rnb.getOption("exploratory.columns"),
  points.per.group = rnb.getOption("distribution.subsample")
)
}
\arguments{
\item{rnb.set}{HumanMethylation450K dataset as an object of type \code{\linkS4class{RnBSet}}.}

\item{report}{Report to contain the methylation deviation section. This must be an object of type
\code{\linkS4class{Report}}.}

\item{columns}{Optional; predefined column names (in the form of a \code{character} vector) or indices (an
\code{integer} vector) in the sample annotation table. Only these columns are considered for grouping
samples and defining profiles. All other columns in the phenotype table are ignored.}

\item{points.per.group}{the targeted number of points (T) per group. Set this to a value < 1 to disable subsampling. More
information in the Details section}
}
\value{
The modified report.
}
\description{
Computes the distributions of beta values across various sample groups and adds a corresponding section to the
report.
}
\section{Details}{

If subsampling is enabled (i.e. \code{points.per.group}>0), 
observations per group are subsampled according to the following procedure:
Given K groups and numbers of observed beta values per group
N_1,...,N_K, and the target number of points per group T: the total number of points N = sum(N_1,...,N_K) is computed
Afterwards the proportions p_k = N_k/N is computed and from each group, S_k = p_k*(K*T) observations
are randomly selected from all observations belonging to group k.
}

\author{
Fabian Mueller
}
