% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{rnb.run.analysis}
\alias{rnb.run.analysis}
\title{RnBeads Analysis Pipeline}
\usage{
rnb.run.analysis(
  dir.reports,
  data.source = NULL,
  sample.sheet = NULL,
  data.dir = NULL,
  GS.report = NULL,
  GEO.acc = NULL,
  data.type = rnb.getOption("import.default.data.type"),
  initialize.reports = TRUE,
  build.index = TRUE,
  save.rdata = TRUE
)
}
\arguments{
\item{dir.reports}{Directory to host the generated report files. This must be a \code{character} of length one
that specifies either a non-existent path (when \code{initialize.reports} is \code{TRUE}),
or an existing directory (when \code{initialize.reports} is \code{FALSE}). In the latter
case, a call to \code{\link{rnb.initialize.reports}} might be required before viewing the
reports.}

\item{data.source}{Methylation dataset as an object of type inheriting \code{\linkS4class{RnBSet}}, or a
\code{character} vector specifying the location of the data items on disk. The expected
length of the vector differs for different values of \code{data.type};
see \code{\link{rnb.execute.import}} for a more detailed description. If set, the parameters
   \code{sample.sheet}, \code{data.dir}, \code{GS.report}, \code{GEO.acc} will be ignored.}

\item{sample.sheet}{A spreadsheet-like text file with sample annotations. The required columns are different
for different values of \code{data.type}.}

\item{data.dir}{For \code{data.type \%in\% c("data.dir", "idat.dir", "bed.dir")} a character singleton
specifying the location of the directory with data files. The directory should have zero
depth, i.e. should contain no subdirectories.}

\item{GS.report}{GenomeStudio report file. \code{data.type} will be automatically set to \code{"GS.report"}.}

\item{GEO.acc}{Gene Expression Omnibus accession of the data series with HumanMethylation450 data.
\code{data.type} will be automatically set to \code{"GEO"}.}

\item{data.type}{\code{character} vector of length one specifying the type of the input data.
The value must be one of \code{"data.dir"}, \code{"idat.dir"}, \code{"GS.report"},
\code{"GEO"} or \code{"rnb.set"}. See \code{\link{rnb.execute.import}} for a more detailed
description.}

\item{initialize.reports}{Flag indicating if the report's directory must be initialized. If this parameter is set to
\code{TRUE}, this function attempts to create the path specified by \code{dir.reports}.
Otherwise, \code{dir.reports} is expected to signify an existing directory.}

\item{build.index}{Flag indicating if a report index file (named \code{"index.html"}) should be created after
all modules in the pipeline complete their analyses. If this is \code{TRUE}, the index file
is also displayed using the function \code{\link{rnb.show.report}}.}

\item{save.rdata}{Flag indicating whether important data objects (the filtered and unfiltered RnBSets,
differential methylation) should be saved to an RData file in the reports folder.}
}
\value{
Invisibly, the loaded, normalized and/or possibly filtered dataset as an object of type inheriting
        \code{\linkS4class{RnBSet}}.
}
\description{
Starts the \pkg{RnBeads} analysis pipeline on the given dataset. It loads the dataset if it is specified as a
location.
}
\seealso{
\link[=rnb.run.import]{RnBeads modules}
}
\author{
Yassen Assenov
}
