% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClass.R
\name{RmmquantRun}
\alias{RmmquantRun}
\title{Main Rmmquant function.}
\usage{
RmmquantRun(
  annotationFile = "",
  readsFiles = character(0),
  genomicRanges = GRanges(),
  genomicRangesList = GRangesList(),
  sampleNames = character(0),
  overlap = NA_integer_,
  strands = character(0),
  sorts = logical(0),
  countThreshold = NA_integer_,
  mergeThreshold = NA_real_,
  printGeneName = FALSE,
  quiet = TRUE,
  progress = FALSE,
  nThreads = 1,
  formats = character(0),
  nOverlapDiff = NA_integer_,
  pcOverlapDiff = NA_real_,
  lazyload = FALSE
)
}
\arguments{
\item{annotationFile}{The annotation file}

\item{readsFiles}{The reads files}

\item{genomicRanges}{The annotation, in a
\code{GenomicRanges} format.}

\item{genomicRangesList}{The annotation, in a
\code{GenomicRangesList} format.}

\item{sampleNames}{The name of the samples}

\item{overlap}{The minimum number of overlapping base pairs to
declare a match.}

\item{strands}{Whether annotation of the same strand should be
considered.}

\item{sorts}{Whether the files are sorted.}

\item{countThreshold}{The reads files}

\item{mergeThreshold}{The reads files}

\item{printGeneName}{Whether the (vernacular) gene name is reported.}

\item{quiet}{Shut Rmmquant up.}

\item{progress}{Print the progress of the tool.}

\item{nThreads}{The number of threads.}

\item{formats}{The format of the reads files (SAM or BAM).}

\item{nOverlapDiff}{Difference of overlap between a primary map and a
secondary map.}

\item{pcOverlapDiff}{Ratio of overlap between a primary map and a
secondary map.}

\item{lazyload}{Usual for S4 functions.}
}
\value{
A \code{SummerizedExperiment}.
}
\description{
Main Rmmquant function.
}
\examples{
dir <- system.file("extdata", package="Rmmquant", mustWork = TRUE)
gtfFile <- file.path(dir, "test.gtf")
samFile <- file.path(dir, "test.sam")
table <- RmmquantRun(gtfFile, samFile)

}
