\name{result.exon}
\alias{result.exon}
\docType{data}
\title{
An example of exon-level differential pattern analysis result
}
\description{
An example output generated by the differential pattern analysis 
function  \code{diffPatternTestExon}, including counts per exon, 
exon-level differential pattern results, etc.}
\usage{data("result.exon")}
\format{
A list of 5
\describe{
\item{bin}{A list object of exon-level test results. Each element 
of the list is the result from  a gene, containing columns: \code{pvalue},
\code{log2FoldChange}, the adjusted p-value by method "gtxr", and other exon
genomic information.}
\item{gene}{Gene-level differential pattern results, including T-value, 
p-value, and q-value}
\item{method}{See \code{diffPatternTestExon}}
\item{exon}{Counts per exon, binned from \code{data}, for
the final differential pattern analysis in the format of a list of named
matrices. In each element of the list, rows correspond to replicates, 
columns correspond to exons.}
\item{data}{The ribosome P-site coverage tracks in the format of 
a list of named matrices. In each element of the list, rows correspond to 
replicates, columns correspond to bps.}
\item{classlabel}{See \code{diffPatternTestExon}}
}
}
\source{
The data was adapted from Kasari et al 2019.
}
\examples{
data(result.exon)
tracks.exon <- exonTrack(data = result.exon, gene = "YDR050C")
}
\keyword{datasets}
