% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rhisat2.R
\name{hisat2_build}
\alias{hisat2_build}
\title{Generate HISAT2 index}
\usage{
hisat2_build(
  references,
  outdir,
  ...,
  prefix = "index",
  force = FALSE,
  strict = TRUE,
  execute = TRUE
)
}
\arguments{
\item{references}{Character vector. The path to the files containing the
reference sequences from which to build the HISAT2 index.}

\item{outdir}{Character scalar. The path to the output directory in which to
store the HISAT2 index. If the directory already exists, the function will
throw an error, unless \code{force=TRUE}.}

\item{...}{Additional arguments passed to the binaries.}

\item{prefix}{Character scalar. The prefix to use for the HISAT2 index files.}

\item{force}{Logical scalar. Whether to force overwriting of \code{outdir}.}

\item{strict}{Logical scalar. Whether strict checking of input arguments
should be enforced.}

\item{execute}{Logical scalar. Whether to execute the assembled shell
command. If FALSE, return a string with the command.}
}
\value{
If \code{execute} is TRUE, the output generated by calling the
  \code{hisat2-build} binary. If \code{execute} is FALSE, the
  \code{hisat2-build} command.
}
\description{
This function can be used to call the \code{hisat2-build} binary.
}
\details{
All additional arguments in \code{...} are interpreted as additional
arguments to the HISAT2 binaries. Any flags are supposed to be represented as
logical values (e.g., \code{quiet=TRUE} will be translated into
\code{--quiet}). Parameters with additional input are supposed to be
character or numeric vectors, and the individual elements are collapsed into
a single comma-separated string (e.g., \code{k=2} is translated into \code{-k
2}, \code{bmax=100} into \code{--bmax 100}). Some arguments to the HISAT2
binaries will be ignored if they are already handled as explicit function
arguments. See the output of \code{hisat2_build_usage()} for details about
available parameters.
}
\examples{
tmp <- tempdir()
refs <- list.files(system.file(package="Rhisat2", "extdata/refs"),
                   full.names=TRUE, pattern="\\\\.fa$")
x <- hisat2_build(references=refs, outdir=file.path(tmp, "index"),
                  force=TRUE)
head(x)
list.files(file.path(tmp, "index"))

}
\references{
Kim D, Langmead B and Salzberg SL. HISAT: a fast spliced aligner with low
memory requirements. Nature Methods 12:357-360 (2015).
}
\author{
Charlotte Soneson, based on code from Florian Hahne.
}
