% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rhisat2.R
\name{hisat2}
\alias{hisat2}
\title{Align reads with HISAT2}
\usage{
hisat2(
  sequences,
  index,
  ...,
  type = c("single", "paired"),
  outfile,
  force = FALSE,
  strict = TRUE,
  execute = TRUE
)
}
\arguments{
\item{sequences}{If \code{type} is \code{single}, a character vector of file
names if the additional argument \code{c} is FALSE, otherwise a vector of
read sequences. If \code{type} is \code{paired}, a length-2 list of file
names or sequences, where the first list item corresponds to the first mate
pair sequences, and the second list item to the second mate pair sequences.}

\item{index}{Character scalar. The path+prefix of the HISAT2 index to align
against (in the form \code{<path/to/index>/<prefix>}).}

\item{...}{Additional arguments passed to the binaries.}

\item{type}{Character scalar, either "single" or "paired". If \code{single},
the input sequences are interpreted as single-end reads. If \code{paired},
they are supposed to be paired reads.}

\item{outfile}{(optional) Character scalar. The path to the output file. If
missing, the alignments will be returned as an R character vector.}

\item{force}{Logical scalar. Whether to force overwriting of \code{outdir}.}

\item{strict}{Logical scalar. Whether strict checking of input arguments
should be enforced.}

\item{execute}{Logical scalar. Whether to execute the assembled shell
command. If FALSE, return a string with the command.}
}
\value{
If \code{execute} is TRUE, the output generated by calling the
  \code{hisat2} binary. If \code{execute} is FALSE, the \code{hisat2}
  command.
}
\description{
The function can be used to call the \code{hisat2} binary.
}
\details{
All additional arguments in \code{...} are interpreted as additional
arguments to the HISAT2 binaries. Any flags are supposed to be represented as
logical values (e.g., \code{quiet=TRUE} will be translated into
\code{--quiet}). Parameters with additional input are supposed to be
character or numeric vectors, and the individual elements are collapsed into
a single comma-separated string (e.g., \code{k=2} is translated into \code{-k
2}, \code{bmax=100} into \code{--bmax 100}). Some arguments to the HISAT2
binaries will be ignored if they are already handled as explicit function
arguments. See the output of \code{hisat2_usage()} for details about
available parameters.
}
\examples{
tmp <- tempdir()
refs <- list.files(system.file("extdata/refs", package="Rhisat2"),
                   full.names=TRUE, pattern="\\\\.fa$")
hisat2_build(references=refs, outdir=file.path(tmp, "index"),
             force=TRUE, prefix="index")
reads <- list.files(system.file("extdata/reads", package="Rhisat2"),
                    full.names=TRUE, pattern="\\\\.fastq$")
hisat2(sequences=as.list(reads), index=file.path(tmp, "index/index"),
       type="paired", outfile=file.path(tmp, "out.sam"), force=TRUE)

}
\references{
Kim D, Langmead B and Salzberg SL. HISAT: a fast spliced aligner with low
memory requirements. Nature Methods 12:357-360 (2015).
}
\author{
Charlotte Soneson, based on code from Florian Hahne.
}
