% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randomizeFeaturesTxIA.R
\name{randomizeFeaturesTxIA}
\alias{randomizeFeaturesTxIA}
\title{Randomize features into transcriptome}
\usage{
randomizeFeaturesTxIA(RS, txdb, type = "mature", N = 1, ...)
}
\arguments{
\item{RS}{The feature being randomized. It should be a \code{GRanges} or \code{GRangesList} object.}

\item{txdb}{A TxDb object.}

\item{type}{A character object. Default is "mature". It accepts options "mature", "full", "fiveUTR", "CDS" or "threeUTR", with which one can get corresponding types of transcriptome regions.}

\item{N}{Randomization times.}

\item{...}{Any additional parameters needed.}
}
\value{
A \code{GRangesList} object. The name of each element is the id of the transcript where the corresponding range is located.
}
\description{
Randomize features into transcriptome, especially for the features that have isoform ambiguity.
}
\examples{
library(TxDb.Hsapiens.UCSC.hg19.knownGene)
file <- system.file(package="RgnTX", "extdata/m6A_sites_data.rds")
m6A_sites_data <- readRDS(file)
txdb <- TxDb.Hsapiens.UCSC.hg19.knownGene
RS1 <- m6A_sites_data[1:100]
RS <- randomizeFeaturesTxIA(RS1, txdb, N = 1)
}
\seealso{
\code{\link{randomizeTransByOrder}}, \code{\link{randomizeFeaturesTx}}, \code{\link{randomizeTx}}
}
