% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getStopCodon.R
\name{getStopCodon}
\alias{getStopCodon}
\title{getStopCodon}
\usage{
getStopCodon(trans_ids, txdb, ...)
}
\arguments{
\item{trans_ids}{A character object containing transcript ids.}

\item{txdb}{A TxDb object.}

\item{...}{Any additional parameters needed.}
}
\value{
A \code{numeric} object.
}
\description{
Get stop codon regions for input transcripts. This is an example of customPick function.
}
\examples{
library(TxDb.Hsapiens.UCSC.hg19.knownGene)
txdb <- TxDb.Hsapiens.UCSC.hg19.knownGene
trans.ids <- c("170", "782", "974", "1364", "1387")
RS2 <- getStopCodon(trans.ids, txdb)
}
