% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPermSpaceByFeatures.R
\name{getPermSpaceByFeatures}
\alias{getPermSpaceByFeatures}
\title{Get permutation space for features}
\usage{
getPermSpaceByFeatures(features, txdb, type = "mature")
}
\arguments{
\item{features}{A \code{GRanges} object.}

\item{txdb}{A TxDb object.}

\item{type}{A character object. Default is "mature". It accepts options "mature", "full", "fiveUTR", "CDS" or "threeUTR", with which one can get corresponding types of regions over transcriptome.}
}
\value{
A list object, which contains two elements.
\itemize{
\item \bold{\code{perm.space:}} A \code{GRangesList} object that includes all the transcripts input features may overlap with.
\item \bold{\code{index:}} It contains a series of numbers indicating which feature these transcripts are respectively associated with.
}
}
\description{
This function returns a default permutation space for features with isoform ambiguity. The default permutation space of a feature is the aggregate of the multiple transcripts it may overlap with. It requires the input feature to be \code{GRanges} format.
}
\examples{
library(TxDb.Hsapiens.UCSC.hg19.knownGene)
txdb <- TxDb.Hsapiens.UCSC.hg19.knownGene
file <- system.file(package="RgnTX", "extdata/m6A_sites_data.rds")
m6A_sites_data <- readRDS(file)
permSpace <- getPermSpaceByFeatures(features = m6A_sites_data[1:100], txdb)
}
\seealso{
\code{\link{getPermSpaceByTxID}}, \code{\link{getPermSpaceByType}}
}
