% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GRanges2GRangesList.R
\name{GRanges2GRangesList}
\alias{GRanges2GRangesList}
\title{Convert a GRanges object to a GRangesList object}
\usage{
GRanges2GRangesList(A = NULL)
}
\arguments{
\item{A}{A \code{GRanges} object.}
}
\value{
A \code{GRangesList} object.
}
\description{
Convert a \code{GRanges} object to a \code{GRangesList} object. The output region set follows the format required by the main permutation test functions.
}
\details{
If input \code{GRanges} object has a metadata named as "group",
ranges having the same group number represent a region. If not, a range is a region.
A region in the input set will be outputted as a list element IN returned
\code{GRangesList} object.
}
\examples{
library(GenomicRanges)
GRanges.object <- GRanges(
    Rle(c("chr2", "chr2", "chr1", "chr3")),
    IRanges(1:4, width = 5)
)
# Assign the first and the second ranges to the same element.
GRanges.object$group <- c(1, 1, 2, 3)
GRangesList.object <- GRanges2GRangesList(GRanges.object)
}
\seealso{
\code{\link{GRanges2GRangesList}}
}
