% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{trimSummary}
\alias{trimSummary}
\title{Summary of Fastq adapter and low quality trimming}
\usage{
trimSummary(json)
}
\arguments{
\item{json}{the output json of function rfastq. [json]}
}
\value{
a data frame.
}
\description{
generate a data frame of the Fastq trim summary.
}
\examples{
outputPrefix <- tempfile(tmpdir = tempdir())
se_read1 <- system.file("extdata","Fox3_Std_small.fq.gz",package="Rfastp")
se_json_report <- rfastp(read1 = se_read1, outputFastq = outputPrefix,
   thread = 4, adapterSequenceRead1 = 'GTGTCAGTCACTTCCAGCGG')
trim_summary <- trimSummary(se_json_report)

}
\author{
Wei Wang
}
