% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plotRegTarExpr}
\alias{plotRegTarExpr}
\title{Plot regulator and its targets expression}
\usage{
plotRegTarExpr(
  object,
  reg,
  n = 1000,
  scale = TRUE,
  tarCol = "black",
  tarColAlpha = 0.1,
  regCol = "#ffaa00",
  xlab = "Samples",
  ylab = "Z-scores",
  ...
)
}
\arguments{
\item{object}{a RegenrichSet object, to which at
least \code{\link{regenrich_diffExpr}} and \code{\link{regenrich_network}}
functions have been applied.}

\item{reg}{a regulator to plot.}

\item{n}{the maximun number of targets to plot.}

\item{scale}{logical, whether gene expression is z-score normalized.}

\item{tarCol}{the color of the lines for the targets of the regulator.}

\item{tarColAlpha}{numeric, ranging from 0 to 1, indicating transparancy
of target lines.}

\item{regCol}{the color of the line for the 'reg'.}

\item{xlab}{x label of plot.}

\item{ylab}{y label of plot.}

\item{...}{other parameters in \code{\link{ggplot}} function.}
}
\value{
a ggplot object.
}
\description{
Plot regulator and its targets expression
}
\examples{
# constructing a RegenrichSet object
colData = data.frame(patientID = paste0('Sample_', seq(50)),
                     week = rep(c('0', '1'), each = 25),
                     row.names = paste0('Sample_', seq(50)), 
                     stringsAsFactors = TRUE)
design = ~week
reduced = ~1
set.seed(123)
cnts = matrix(as.integer(rnbinom(n=1000*50, mu=100, size=1/0.1)), ncol=50,
              dimnames = list(paste0('gene', seq(1000)), rownames(colData)))

cnts[5,26:50] = cnts[5,26:50] + 50L # add reads to gene5 in some samples.
id = sample(31:1000, 20) # randomly select 20 rows, and assign reads.
cnts[id,] = vapply(cnts[5,], function(x){
  as.integer(rnbinom(n = 20, size = 1/0.02, mu = x))},
  FUN.VALUE = rep(1L, 20))

object = RegenrichSet(expr = cnts,
                      colData = colData,
                      method = 'LRT_DESeq2', minMeanExpr = 0,
                      design = design, reduced = reduced, fitType = 'local',
                      networkConstruction = 'COEN',
                      enrichTest = 'FET',
                      reg = paste0('gene', seq(30)))

## RegEnrich analysis
object = regenrich_diffExpr(object)

# Set a random softPower, otherwise it is difficult to achive a
# scale-free network because of a randomly generated count data.
object = regenrich_network(object, softPower = 3)
object = regenrich_enrich(object)
object = regenrich_rankScore(object)

## plot expression of a regulator and its targets.
plotRegTarExpr(object, reg = 'gene5')
plotRegTarExpr(object, reg = 'gene27')
}
