% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DEA.R
\name{getResultsNames}
\alias{getResultsNames}
\title{Inference the name of results of DESeq analysis by a formula
(or model matrix) and sample information}
\usage{
getResultsNames(design, pData = NULL)
}
\arguments{
\item{design}{either a formula or a model matrix.}

\item{pData}{a data frame, showing the information of each sample.
If design is
a formula, the pData must be include the columns that identical
to the terms of
the design formula. If design is a model matrix, then pData is not used.
Default is NULL.}
}
\value{
the names of contrast parameter (list of character format) that
\code{\link{regenrich_diffExpr}} and \code{\link{results}}
function can use, and it is the same as the value that
\code{\link{resultsNames}} function returns.
}
\description{
Inference the name of results of DESeq analysis by a formula
(or model matrix) and sample information
}
\examples{
# formula with intercept
design = ~condition
pData = data.frame(condition = factor(c('A', 'A', 'A', 'B', 'B', 'B'),
                                      c('A', 'B')))
getResultsNames(design, pData)

# formula without intercept
design = ~0+condition
getResultsNames(design, pData)

# formula with two terms
design = ~condition+treatment
pData = data.frame(condition = factor(rep(c('A', 'B'), each= 4),
                                      c('A', 'B')),
                   treatment = factor(rep_len(c('Ctrl', 'Treat'), 8),
                                      c('Ctrl', 'Treat')))
getResultsNames(design, pData)

# formula with two terms and an interaction term
design = ~condition+treatment+condition:treatment
getResultsNames(design, pData)

# design is a model matrix
pData = data.frame(condition = factor(rep(c('A', 'B'), each= 4),
                                      c('A', 'B')),
                   treatment = factor(rep_len(c('Ctrl', 'Treat'), 8),
                                      c('Ctrl', 'Treat')))
design = model.matrix(~condition+treatment, pData)
getResultsNames(design)
}
