% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-ModularExperiment.R,
%   R/methods-ReducedExperiment.R
\name{nModules,ModularExperiment-method}
\alias{nModules,ModularExperiment-method}
\alias{individual_dim}
\alias{nComponents}
\alias{nFeatures}
\alias{nModules}
\alias{nSamples}
\alias{nComponents,ReducedExperiment-method}
\alias{nSamples,ReducedExperiment-method}
\alias{nFeatures,ReducedExperiment-method}
\title{Prints individual lengths of samples, components and features}
\usage{
\S4method{nModules}{ModularExperiment}(object)

\S4method{nComponents}{ReducedExperiment}(object)

\S4method{nSamples}{ReducedExperiment}(object)

\S4method{nFeatures}{ReducedExperiment}(object)
}
\arguments{
\item{object}{\link[ReducedExperiment]{ReducedExperiment} object.}
}
\value{
The number of samples (\code{nSamples}), features (\code{nFeatures})
or dimensionally-reduced components (\code{nComponents}) are returned.
}
\description{
Prints individual lengths of samples, components and features
}
\examples{
# Create a randomised ReducedExperiment
re <- ReducedExperiment:::.createRandomisedReducedExperiment(100, 50, 10)

# Get the dimensions
nComponents(re) # 10
nSamples(re) # 50
nFeatures(re) # 10

# For a ModularExperiment we can alternatively use nModules
me <- ReducedExperiment:::.createRandomisedModularExperiment(100, 50, 10)
nComponents(me) # 10
nModules(me) # 10

}
\seealso{
\link[ReducedExperiment]{dim,ReducedExperiment-method}
}
\author{
Jack Gisby
}
