% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Misc.R
\docType{package}
\name{RedeR-package}
\alias{RedeR}
\alias{RedeR-package}
\title{RedeR: Interactive visualization and manipulation of nested networks}
\description{
RedeR is an R-based package combined with a stand-alone Java application
for interactive visualization and manipulation of nested networks.
}
\details{
\tabular{ll}{
Package: \tab RedeR\cr
Type: \tab Software\cr
License: \tab GPL-3\cr
Maintainer: \tab Mauro Castro \email{mauro.a.castro@gmail.com}\cr
}
}
\section{Index}{

\tabular{ll}{
\link{startRedeR}:
\tab Method to launch RedeR application from R.\cr
\link{pingRedeR}:
\tab Test the R-to-Java interface of an active RedeR session.\cr
\link{addGraphToRedeR}:
\tab Methods to display igraph objects in the RedeR application.\cr
\link{getGraphFromRedeR}:
\tab Methods to wrap up RedeR graphs into igraph's R objects.\cr
\link{addLegendToRedeR}:
\tab Methods to display legends in the RedeR app.\cr
\link{relaxRedeR}:
\tab Start RedeR's hierarchical force-directed interactive layout.\cr
\link{resetRedeR}:
\tab Reset an active RedeR session.\cr
\link{exitRedeR}:
\tab Close an active RedeR session.\cr
}
Further information is available in the vignettes by typing
\code{vignette('RedeR')}. Documented topics are also available in
HTML by typing \code{help.start()} and selecting the RedeR package
from the menu.
}

\references{
Castro MAA, Wang X, Fletcher MNC, Meyer KB, Markowetz F. RedeR:
R/Bioconductor package for representing modular structures, nested
networks and multiple levels of hierarchical associations.
Genome Biology 13:R29, 2012.
}
\seealso{
Useful links:
\itemize{
  \item \doi{10.1186/gb-2012-13-4-r29}
}

}
\author{
\strong{Maintainer}: Mauro Castro \email{mauro.a.castro@gmail.com} (\href{https://orcid.org/0000-0003-4942-8131}{ORCID})

Other contributors:
\itemize{
  \item Xin Wang [contributor]
  \item Florian Markowetz [contributor]
}

}
\keyword{internal}
