% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aux_getDbRegionsLoc.R
\name{getDbRegionsLoc}
\alias{getDbRegionsLoc}
\title{Gets the region location for the given database IDs.}
\usage{
getDbRegionsLoc(featherFilePath, spltChr = "__", indexCol = NULL)
}
\arguments{
\item{featherFilePath}{Path to the rankings database}

\item{spltChr}{Character(s) used to split the prefix from the region location.
The default is used for current Drosophila versions. Use NULL to skip.}

\item{indexCol}{Column name including the motif/feature IDs. By default it will use the first column.}
}
\value{
The region locations in a GRanges object, with the original region ID as name.

See the package vignette for examples and more details:
\code{vignette("RcisTarget")}
}
\description{
Gets the region location based on the region ID.
Only needed for drosophila\bold{drosophila} (fruit fly) regions.

For \bold{human/mouse} the region locations are stored in a separate object 
(i.e. \code{}). This function is not needed.
}
\examples{
\dontrun{
featherFilePath <- "~/databases/dm6-regions-11species.mc9nr.feather"
dbRegionsLoc <- getDbRegionsLoc(featherFilePath)
}
}
