% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aux_addLogo.R
\name{addLogo}
\alias{addLogo}
\title{Add motif logo to RcisTarget results table}
\usage{
addLogo(motifEnrDT, addHTML = TRUE, dbVersion = NULL, motifCol = "motif")
}
\arguments{
\item{motifEnrDT}{Results from RcisTarget (data.table)}

\item{addHTML}{Whether to add the HTML tag <img> around the URL or not
(boolean).}

\item{dbVersion}{The default value 'v10nr_clust' corresponds to the 
latest version of the databases (currently version 10). 
For previous databases use 'v8' or 'v9', as appropriate.}

\item{motifCol}{Name of the column which contains the logo ID.}
}
\value{
Returns the results table with a new column: 'logo'.
This column contains either a URL with the logo image, or the HTML code to
show the logo [e.g. with datatable()].
}
\description{
Adds a column containing the logo URL to RcisTarget results
table.
}
\examples{
# Run the enrichment (or load previous results)
load(paste(file.path(system.file('examples', package='RcisTarget')),
           "motifEnrichmentTable_wGenes.RData", sep="/"))

# Add link to logo
newMotifErnTable <- addLogo(motifEnrichmentTable_wGenes)

# Show table
library(DT)
datatable(newMotifErnTable[,-c("enrichedGenes"), with=FALSE],
          escape = FALSE,
          filter="top",
          options=list(pageLength=5))

}
\seealso{
\code{vignette("showLogo")} to directly show the table as HTML. 
See the package vignette for more examples:
\code{vignette("RcisTarget")}
}
