% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RaggedExperiment-package.R
\docType{package}
\name{RaggedExperiment-package}
\alias{RaggedExperiment-package}
\title{RaggedExperiment: Range-based data representation package}
\description{
\link{RaggedExperiment} allows the user to represent, copy
    number, mutation, and other types of range-based data formats
    where optional information about samples can be provided. At
    the backbone of this package is the \link[GenomicRanges]{GRangesList}
    class. The RaggedExperiment class uses this representation
    and presents the data in a couple of different ways:
    \itemize{
    \item rowRanges
    \item colData
    }
    The \link[RaggedExperiment:RaggedExperiment-class]{rowRanges}
    method will return the internal \code{GRangesList} representation of the
    dataset. A distinction between the
    \link[SummarizedExperiment]{SummarizedExperiment} and the
    \code{RaggedExperiment} classes is that the \link{RaggedExperiment} class
    allows for ragged ranges, meaning that there may be a different number of
    ranges or rows per sample.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://bioconductor.github.io/RaggedExperiment}
  \item \url{https://bioconductor.org/packages/RaggedExperiment}
  \item Report bugs at \url{https://github.com/Bioconductor/RaggedExperiment/issues}
}

}
\author{
\strong{Maintainer}: Marcel Ramos \email{marcel.ramos@sph.cuny.edu} (\href{https://orcid.org/0000-0002-3242-0582}{ORCID})

Authors:
\itemize{
  \item Martin Morgan \email{martin.morgan@roswellpark.org}
}

Other contributors:
\itemize{
  \item Lydia King \email{L.King18@nuigalway.ie} [contributor]
}

}
