% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlationPlot.R
\name{correlationPlot}
\alias{correlationPlot}
\title{Correlation plot to compare estimated correlations with true correlations.}
\usage{
correlationPlot(
  true,
  est,
  plot.genes = sample(seq_len(dim(true)[1]), 18),
  boxes = TRUE,
  title,
  line = -1
)
}
\arguments{
\item{true}{A matrix of true gene-gene correlation values.}

\item{est}{A matrix of estimated gene expression values.}

\item{plot.genes}{A vector of indices of genes used in plotting; 
the suggested length of this vector is 18.}

\item{boxes}{A logical scalar to indicate whether boxes 
are drawn around sets of 6 genes; only available if \code{plot.genes} has length 18.}

\item{title}{A character string describing the title of the plot.}

\item{line}{on which MARgin line, starting at 0 counting outwards.}
}
\value{
\code{correlationPlot} returns a plot.
}
\description{
\code{correlationPlot} produces a correlation plot to compare true and estimated
}
\details{
The upper triangle of the correlation plot shows the true gene-gene correlation values,
while the lower triangle of the correlation plot shows the gene-gene correlation values
calculated from the estimated gene expression values. This is possible because correlation
matrices are symmetric.
}
\examples{
Y<-simulateGEdata(500, 500, 10, 2, 5, g=NULL, Sigma.eps=0.1, 
250, 100, intercept=FALSE, check.input=FALSE)
correlationPlot(Y$Sigma, Y$Y, title="Raw", 
plot.genes=c(sample(1:100, 6), sample(101:250, 6), sample(251:500, 6)))
}
\seealso{
\code{\link[corrplot]{corrplot}}
}
\author{
Saskia Freytag
}
