% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hclust_semi.R
\name{hclust_semisupervised}
\alias{hclust_semisupervised}
\title{Semi-supervised hierarchical clustering}
\usage{
hclust_semisupervised(
  data,
  groups,
  dist_method = "euclidean",
  hclust_method = "complete"
)
}
\arguments{
\item{data}{a data.frame to be clustered by rows}

\item{groups}{a list of vectors. If we unlist(groups), all elements must be
present in the rownames of data. Each vector in the list will be treated as
a separate group for the hierarchical clustering, and rejoined in order at
the end.}

\item{dist_method}{a distance computation method. Must be one of "euclidean", 
"maximum", "manhattan", "canberra", "binary", "minkowski", "pearson", "spearman"}

\item{hclust_method}{an agglomeration method. Should be a method supported by
hclust, one of:  "ward.D", "ward.D2", "single", "complete", "average" (= UPGMA), 
"mcquitty" (= WPGMA), "median" (= WPGMC) or "centroid" (= UPGMC).}
}
\value{
hclust_semisupervised returns a list. The first element of the list
is the data, reordered so that the merged hclust object will work. The second
element is the result of the semi-supervised hierarchical clustering.
}
\description{
This function will run a semi-supervised hierarchical clustering, using
prior knowledge to initialize clusters, and then unsupervised clustering on 
the unlabeled data.
}
\examples{

#--- add  unique labels to 'iris' data
rownames(iris) <- paste(iris$Species, formatC(1:nrow(iris), width=3, flag="0"), sep="_")

#--- unsupervised clustering
hc <- hclust(dist(iris[, -5]))
plot(hc, hang=-1, cex=0.5)

#--- semi-supervised clustering
hc_ssuper <- hclust_semisupervised(data = iris[, -5], 
                                   groups = split(rownames(iris), iris$Species))
plot(hc_ssuper, hang=-1, cex=0.5)


}
