% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize.batches.R
\name{summarize.batches}
\alias{summarize.batches}
\title{summarize.batches}
\usage{
summarize.batches(
  sets = NULL,
  probe.parameters = list(),
  batches,
  load.batches = FALSE,
  mc.cores = 1,
  cdf = NULL,
  bg.method = "rma",
  normalization.method = "quantiles",
  verbose = TRUE,
  save.batches.dir = ".",
  unique.run.identifier = NULL,
  save.batches = FALSE,
  set.inds,
  speedup = FALSE,
  summarize.with.affinities = FALSE
)
}
\arguments{
\item{sets}{Probesets to summarize}

\item{probe.parameters}{Optional probe parameters, including priors.}

\item{batches}{Data batches for online learning}

\item{load.batches}{Logical. Load precalculated data for the batches.}

\item{mc.cores}{Number of cores for parallel computation}

\item{cdf}{CDF for alternative probeset definitions}

\item{bg.method}{Background correction method}

\item{normalization.method}{Normalization method}

\item{verbose}{Print progress information}

\item{save.batches.dir}{Specify the output directory for temporary batch saves.}

\item{unique.run.identifier}{Define identifier for this run for naming the temporary batch files. By default, a random id is generated.}

\item{save.batches}{Save batches?}

\item{set.inds}{Probeset indices}

\item{speedup}{Speed up calculations with approximations.}

\item{summarize.with.affinities}{Use affinity estimates in probe summarization step. Default: FALSE.}
}
\value{
Expression matrix: probesets x samples.
}
\description{
Summarize batches.
}
\details{
Sweeps through the batches. Summarizes the probesets within each batch based on the precalculated model parameter point estimates.
}
\examples{
# 
}
\references{
See citation("RPA")
}
\author{
Leo Lahti \email{leo.lahti@iki.fi}
}
\keyword{utilities}
