% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpa.R
\name{rpa}
\alias{rpa}
\title{rpa}
\usage{
rpa(
  abatch = NULL,
  verbose = FALSE,
  bg.method = "rma",
  normalization.method = "quantiles.robust",
  cdf = NULL,
  cel.files = NULL,
  cel.path = NULL,
  probe.parameters = NULL,
  mc.cores = 1,
  summarize.with.affinities = FALSE
)
}
\arguments{
\item{abatch}{An AffyBatch object.}

\item{verbose}{Print progress information during computation.}

\item{bg.method}{Specify background correction method. Default: "rma". See bgcorrect.methods() for other options.}

\item{normalization.method}{Specify quantile normalization method. Default: "pmonly". See normalize.methods(Dilution) for other options.}

\item{cdf}{Specify an alternative CDF environment. Default: none.}

\item{cel.files}{List of CEL files to preprocess.}

\item{cel.path}{Path to CEL file directory.}

\item{probe.parameters}{A list, each element corresponding to a probe set. Each probeset element has the following optional elements: mu (affinity), tau2 (variance), alpha (shape prior), beta (scale prior). Each of these elements contains a vector over the probeset probes, specifying the probe parameters according to the RPA model. If variance is given, it overrides the priors. Can be also used to set user-specified priors for the model parameters. Not used tau2.method = "var". The prior parameters alpha and beta are prior parameters for inverse Gamma distribution of probe-specific variances. Noninformative prior is obtained with alpha, beta -> 0.  Not used with tau2.method 'var'. Scalar alpha and beta specify an identical inverse Gamma prior for all probes, which regularizes the solution. Can be also specified as lists, each element corresponding to one probeset. May also include quantile.basis}

\item{mc.cores}{Number of cores for parallelized processing.}

\item{summarize.with.affinities}{Use affinity estimates in probe summarization step. Default: FALSE.}
}
\value{
Preprocessed expression matrix in expressionSet format
}
\description{
Wrapper for RPA preprocessing.
}
\details{
RPA preprocessing function. Gives an estimate of the probeset-level mean parameter d of the RPA model, and returns these in an expressionSet object. The choices tau2.method = "robust" and d.method = "fast" are recommended. With small sample size and informative prior, d.method = "basic" may be preferable. For very large expression data collections, see rpa.online function.
}
\examples{
# eset <- rpa(abatch)
}
\references{
See citation("RPA")
}
\seealso{
rpa.online, AffyBatch, ExpressionSet, estimate.affinities, rpa.fit
}
\author{
Leo Lahti \email{leo.lahti@iki.fi}
}
\keyword{methods}
