% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/limmavoom_imputed_data_list.R
\name{limmavoom_imputed_data_list}
\alias{limmavoom_imputed_data_list}
\title{limmavoom_imputed_data_list}
\usage{
limmavoom_imputed_data_list(
  gene_intervals,
  DGE,
  imputed_data_list,
  m,
  voom_formula,
  BPPARAM = bpparam()
)
}
\arguments{
\item{gene_intervals}{Output from get_gene_bin_intervals function. A dataframe where each row contains the start (first col) and end (second col) values for each gene bin interval.}

\item{DGE}{A DGEList object.}

\item{imputed_data_list}{Output from impute_by_gene_bin.}

\item{m}{Number of imputed data sets.}

\item{voom_formula}{Formula for design matrix.}

\item{BPPARAM}{A BiocParallelParam object}
}
\value{
A dataframe with coefficient, standard error, sigma, and residual degrees of freedom values from limma-voom gene expression analysis. One row per gene and one set of values per imputed dataset.
}
\description{
Loops through the imputed data list (output from "impute_by_gene_bin" function)
and runs limma-voom RNA seq analysis.
}
\examples{
data(example_data)
data(example_DGE)
intervals <- get_gene_bin_intervals(example_DGE, example_data, n = 10)
gene_bin_impute <- impute_by_gene_bin(example_data,
    intervals,
    example_DGE,
    m = 2
)
coef_se <- limmavoom_imputed_data_list(
    gene_intervals = intervals,
    DGE = example_DGE,
    imputed_data_list = gene_bin_impute,
    m = 2,
    voom_formula = "~x + y + z + a + b"
)

final_res <- combine_rubins(
    DGE = example_DGE,
    model_results = coef_se,
    predictor = "x"
)
}
