% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute_by_gene_bin.R
\name{impute_by_gene_bin}
\alias{impute_by_gene_bin}
\title{impute_by_gene_bin}
\usage{
impute_by_gene_bin(data, intervals, DGE, m, maxit = 10, BPPARAM = bpparam())
}
\arguments{
\item{data}{Sample data with one row per sample. Sample row order should match the col order in the DGEList.}

\item{intervals}{Output from get_gene_bin_intervals function. A dataframe where each row contains the start (first col) and end (second col) values for each gene bin interval.}

\item{DGE}{A DGEList object.}

\item{m}{Number of imputed data sets.}

\item{maxit}{Used by mice function.}

\item{BPPARAM}{A BiocParallelParam object}
}
\value{
A list of sets of n imputed datasets, one per gene bin.
}
\description{
Loops through DGE list using the gene bin intervals from the
"get_gene_bin_intervals" function and makes imputed datasets. For instance,
if n = 100 and intervals contains 200 gene bin intervals, output will be a list of
200 sets of 100 imputed datasets. Each of the 200 sets are imputed
using only the genes in one gene bin.
}
\examples{
data(example_data)
data(example_DGE)
intervals <- get_gene_bin_intervals(example_DGE, example_data, n = 10)
gene_bin_impute <- impute_by_gene_bin(example_data,
    intervals,
    example_DGE,
    m = 2
)
coef_se <- limmavoom_imputed_data_list(
    gene_intervals = intervals,
    DGE = example_DGE,
    imputed_data_list = gene_bin_impute,
    m = 2,
    voom_formula = "~x + y + z + a + b"
)

final_res <- combine_rubins(
    DGE = example_DGE,
    model_results = coef_se,
    predictor = "x"
)
}
