% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/ModifierML-data.R
\name{trainingData}
\alias{trainingData}
\alias{trainingData,ModifierML,GRanges-method}
\alias{trainingData,ModifierML,GRangesList-method}
\title{Assemble training data from aggregate sequence data}
\usage{
trainingData(x, coord, ...)

\S4method{trainingData}{ModifierML,GRanges}(x, coord, ...)

\S4method{trainingData}{ModifierML,GRangesList}(x, coord, ...)
}
\arguments{
\item{x}{a \code{ModifierML} object}

\item{coord}{a \code{GRanges} or a \code{GRangesList} object}

\item{...}{See \code{\link[RNAmodR:subsetByCoord]{subsetByCoord}}
for more details. \code{type} is hard coded to \code{FALSE} to disregard
subsetting by type. In addition, \code{merge} is set to \code{FALSE} by
default, but it can be set to \code{TRUE}.}
}
\value{
a \code{CompressedSplitDataFrameList} with aggregate data and an
addition label column.
}
\description{
\code{trainingData} subsets the aggregate data of a \code{ModifierML} object
to positions as defined by \code{coord}. Positions with an entry in the
\code{mod} column are labeled \code{TRUE}.
}
\examples{
data("dmod",package = "RNAmodR.ML")
setClass("ModMLExample",
         contains = c("RNAModifierML"),
         prototype = list(mod = c("D"),
                          score = "score",
                          dataType = c("PileupSequenceData",
                                       "CoverageSequenceData"),
                          mlModel = character(0)))
data("me",package = "RNAmodR.ML")
nextUPos <- function(gr){
  nextU <- lapply(seq.int(1L,2L),
                  function(i){
                    subseq <- subseq(RNAmodR::sequences(me)[dmod$Parent], start(dmod)+3L)
                    pos <- start(dmod) + 2L +
                      vapply(strsplit(as.character(subseq),""),
                             function(y){which(y == "U")[i]},integer(1))
                    ans <- dmod
                    ranges(ans) <- IRanges(start = pos, width = 1L)
                    ans
                  })
  nextU <- do.call(c,nextU)
  nextU$mod <- NULL
  unique(nextU)
}
nondmod <- nextUPos(dmod)
nondmod <- nondmod[!(nondmod \%in\% dmod)]
coord <- unique(c(dmod,nondmod))
coord <- coord[order(as.integer(coord$Parent))]
trainingData(me,coord)
}
\seealso{
For more details have a look at
\code{\link[RNAmodR:subsetByCoord]{subsetByCoord}}.
}
