% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createMassBank.R
\name{mbWorkflow}
\alias{mbWorkflow}
\title{MassBank record creation workflow}
\usage{
mbWorkflow(
  mb,
  steps = c(1, 2, 3, 4, 5, 6, 7, 8),
  infolist_path = "./infolist.csv",
  gatherData = "online",
  filter = TRUE
)
}
\arguments{
\item{mb}{The \code{mbWorkspace} to work in.}

\item{steps}{Which steps in the workflow to perform.}

\item{infolist_path}{A path where to store newly downloaded compound informations,
which should then be manually inspected.}

\item{gatherData}{A variable denoting whether to retrieve information using several online databases \code{gatherData= "online"}
or to use the local babel installation \code{gatherData= "babel"}. Note that babel is used either way, if a directory is given 
in the settings. This setting will be ignored if retrieval is set to "standard"}

\item{filter}{If \code{TRUE}, the peaks will be filtered according to the standard processing workflow in RMassBank - 
only the best formula for a peak is retained, and only peaks passing multiplicity filtering are retained. If FALSE, it is assumed
that the user has already done filtering, and all peaks in the spectrum should be printed in the record (with or without formula.)}
}
\value{
The processed \code{mbWorkspace}.
}
\description{
Uses data generated by \code{\link{msmsWorkflow}} to create MassBank records.
}
\details{
See the vignette \code{vignette("RMassBank")} for detailed informations about the usage.

Steps:

Step 1: Find which compounds don't have annotation information yet. For these
		 compounds, pull information from several databases (using gatherData).

Step 2: If new compounds were found, then export the infolist.csv and stop the workflow.
		Otherwise, continue.

Step 3: Take the archive data (in table format) and reformat it to MassBank tree format.

Step 4: Compile the spectra. Using the skeletons from the archive data, create
  MassBank records per compound and fill them with peak data for each spectrum.
  Also, assign accession numbers based on scan mode and relative scan no.

Step 5: Convert the internal tree-like representation of the MassBank data into
 flat-text string arrays (basically, into text-file style, but still in memory)

Step 6: For all OK records, generate a corresponding molfile with the structure
  of the compound, based on the SMILES entry from the MassBank record. (This molfile
  is still in memory only, not yet a physical file)

Step 7: If necessary, generate the appropriate subdirectories, and actually write
  the files to disk.

Step 8: Create the list.tsv in the molfiles folder, which is required by MassBank
  to attribute substances to their corresponding structure molfiles.
}
\examples{
\dontrun{
		mb <- newMbWorkspace(w) # w being a msmsWorkspace
		mb <- loadInfolists(mb, "D:/myInfolistPath")
		mb <- mbWorkflow(mb, steps=c(1:3), "newinfos.csv")
		
}
}
\seealso{
\code{\link{mbWorkspace-class}}
}
\author{
Michael A. Stravs, Eawag <michael.stravs@eawag.ch>
}
