% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/leMsMs.r
\name{makeRecalibration}
\alias{makeRecalibration}
\alias{recalibrateSpectra}
\alias{recalibrateSingleSpec}
\title{Recalibrate MS/MS spectra}
\usage{
makeRecalibration(w,  
 	recalibrateBy = getOption("RMassBank")$recalibrateBy,
		recalibrateMS1 = getOption("RMassBank")$recalibrateMS1,
		recalibrator = getOption("RMassBank")$recalibrator,
		recalibrateMS1Window = getOption("RMassBank")$recalibrateMS1Window 
		)

 recalibrateSpectra(rawspec = NULL, rc = NULL, rc.ms1=NULL, w = NULL,
		recalibrateBy = getOption("RMassBank")$recalibrateBy,
		recalibrateMS1 = getOption("RMassBank")$recalibrateMS1)




 recalibrateSingleSpec(spectrum, rc, 
		recalibrateBy = getOption("RMassBank")$recalibrateBy)
}
\arguments{
\item{w}{For \code{makeRecalibration}: to perform the recalibration with. For \code{recalibrateSpectra}: 
the \code{msmsWorkspace} which contains the recalibration curves (alternatively to specifying \code{rc, rc.ms1}).}

\item{recalibrateBy}{Whether recalibration should be done by ppm ("ppm") or by m/z ("mz").}

\item{recalibrateMS1}{Whether MS1 spectra should be recalibrated separately ("separate"),
together with MS2 ("common") or not at all ("none"). Usually taken from settings.}

\item{recalibrator}{The recalibrator functions to be used.
Refer to \code{\link{recalibrate}} for details. Usually taken from settings.}

\item{recalibrateMS1Window}{Window width to look for MS1 peaks to recalibrate (in ppm).}

\item{spectrum}{For \code{recalibrateSingleSpec}:
a \code{MSnbase} \code{Spectrum}-derived object, commonly a \code{RmbSpectrum2} for MS2 or \code{Spectrum1} for MS1.}

\item{rawspec}{For \code{recalibrateSpectra}:an \code{RmbSpectraSetList} of \code{RmbSpectraSet} objects
, as the \code{w@spectra} slot from \code{msmsWorkspace} or any object returned by \code{\link{findMsMsHR}}.
If empty, no spectra are recalibrated, but the recalibration curve is
returned.}

\item{rc, rc.ms1}{The recalibration curves to be used in the recalibration.}
}
\value{
\code{makeRecalibration}: a \code{list(rc, rc.ms1)} with recalibration curves
			for the MS2 and MS1 spectra.

			\code{recalibrateSpectra}: if \code{rawspec} is not \code{NULL}, returns the recalibrated
			spectra as \code{RmbSpectraSetList}. All spectra have their mass recalibrated and evaluation data deleted.

			\code{recalibrateSingleSpec}: the recalibrated \code{Spectrum} (same object, recalibrated masses,
				 evaluation data like assigned formulae etc. deleted).
}
\description{
Recalibrates MS/MS spectra by building a recalibration curve of the
assigned putative fragments of all spectra in \code{aggregatedSpecs}
(measured mass vs. mass of putative associated fragment) and additionally
the parent ion peaks.
}
\details{
Note that the actually used recalibration functions are governed by the
general MassBank settings (see \code{\link{recalibrate}}).

If a set of acquired LC-MS runs contains spectra for two different ion types
(e.g. [M+H]+ and [M+Na]+) which should both be processed by RMassBank, it is
necessary to do this in two separate runs. Since it is likely that one ion type
will be the vast majority of spectra (e.g. most in [M+H]+ mode), and only few
spectra will be present for other specific adducts (e.g. only few [M+Na]+ spectra),
it is possible that too few spectra are present to build a good recalibration curve
using only e.g. the [M+Na]+ ions. Therefore we recommend, for one set of LC/MS runs,
to build the recalibration curve for one ion type 
(\code{msmsWorkflow(mode="pH", steps=c(1:8), newRecalibration=TRUE)})
and reuse the same curve for processing different ion types 
(\code{msmsWorkflow(mode="pNa", steps=c(1:8), newRecalibration=FALSE)}).
This also ensures a consistent recalibration across all spectra of the same batch.
}
\examples{
\dontrun{ 
			rcCurve <- recalibrateSpectra(w, "pH")
			w@spectra <- recalibrateSpectra(mode="pH", rawspec=w@spectra, w=myWorkspace)
			w@spectra <- recalibrateSpectra(mode="pH", rawspec=w@spectra,	rcCurve$rc, rcCurve$rc.ms1)
			}

}
\author{
Michael Stravs, Eawag <michael.stravs@eawag.ch>
}
