% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createMassBank.R
\name{gatherDataUnknown}
\alias{gatherDataUnknown}
\title{Retrieve annotation data}
\usage{
gatherDataUnknown(id, mode, retrieval)
}
\arguments{
\item{id}{The compound ID.}

\item{mode}{\code{"pH", "pNa", "pM", "pNH4", "mH", "mM", "mFA"} for different ions 
([M+H]+, [M+Na]+, [M]+, [M+NH4]+, [M-H]-, [M]-, [M+FA]-).}

\item{retrieval}{A value that determines whether the files should be handled either as "standard",
if the compoundlist is complete, "tentative", if at least a formula is present or "unknown"
if the only know thing is the m/z}
}
\value{
Returns a list of type \code{list(id= \var{compoundID}, ...,
'ACCESSION' = '', 'RECORD_TITLE' = '', )} etc. %% ...
}
\description{
Retrieves annotation data for an unknown compound by using basic information present
}
\details{
Composes the "upper part" of a MassBank record filled with chemical data
about the compound: name, exact mass, structure, CAS no..  
The instrument type is also written into this block (even
if not strictly part of the chemical information). Additionally, index
fields are added at the start of the record, which will be removed later:
\code{id, dbcas, dbname} from the compound list.

Additionally, the fields \code{ACCESSION} and \code{RECORD_TITLE} are
inserted empty and will be filled later on.

This function is used to generate the data in case a substance is unknown,
i.e. not enough information is present to derive anything about formulas or links
}
\examples{

# Gather data for compound ID 131
\dontrun{gatherDataUnknown(131,"pH")}

}
\references{
MassBank record format:
\url{http://www.massbank.jp/manuals/MassBankRecord_en.pdf}
}
\seealso{
\code{\link{mbWorkflow}}
}
\author{
Michael Stravs, Erik Mueller
}
