% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildRecord.R
\name{buildRecord}
\alias{buildRecord}
\alias{buildRecord,RmbSpectraSet-method}
\alias{buildRecord,RmbSpectrum2-method}
\title{Build MassBank records}
\usage{
buildRecord(o, ..., cpd, mbdata, analyticalInfo, additionalPeaks)

\S4method{buildRecord}{RmbSpectraSet}(o, ..., cpd, mbdata, analyticalInfo, additionalPeaks)

\S4method{buildRecord}{RmbSpectrum2}(
  o,
  ...,
  cpd = NULL,
  mbdata = list(),
  analyticalInfo = list(),
  additionalPeaks = NULL
)
}
\arguments{
\item{o}{\code{RmbSpectraSet} or \code{RmbSpectrum2}
The spectra (or single spectrum) should be taken from a compound after analysis (\code{\link{analyzeMsMs}}).
Note that \bold{peaks are not read from this
object anymore}: Peaks come from the \code{aggregated} dataframe (and from
the global \code{additionalPeaks} dataframe; cf. \code{\link{addPeaks}} for
usage information.)}

\item{...}{keyword arguments for intensity normalization and peak selection (see \code{\link{normalize}} and \code{\link{selectPeaks}})}

\item{cpd}{\code{RmbSpectraSet} or missing
In case o is an \code{RmbSpectrum2}, this represents the \code{RmbSpectraSet} it belongs to}

\item{mbdata}{list
The information data block for the record header, as stored in
\code{mbdata_relisted} after loading an infolist.}

\item{analyticalInfo}{A list containing information for the `AC$` section of
a MassBank record, with elements `ai, ac_lc, ac_ms` for general, LC and MS
info respectively.}

\item{additionalPeaks}{data.frame
If present, a table with additional peaks to add into the spectra.
        As loaded with \code{\link{addPeaks}}.}
}
\value{
An object of the same type as was used for the input with new information added to it
}
\description{
Takes a spectra block for a compound, as returned from
\code{\link{analyzeMsMs}}, and an aggregated cleaned peak table, together
with a MassBank information block, as stored in the infolists and loaded via
\code{\link{loadInfolist}}/\code{\link{readMbdata}} and processes them to a
MassBank record
}
\references{
MassBank record format:
\url{http://www.massbank.jp/manuals/MassBankRecord_en.pdf}
}
\seealso{
\code{\link{mbWorkflow}}, \code{\link{addPeaks}},
\code{\link{toMassbank}}
}
\author{
Michael Stravs
}
