% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/leMsMs.r
\name{analyzeMsMs}
\alias{analyzeMsMs}
\alias{analyzeMsMs.formula}
\alias{analyzeMsMs.intensity}
\title{Analyze MSMS spectra}
\usage{
analyzeMsMs(
  msmsPeaks,
  mode = "pH",
  detail = FALSE,
  run = "preliminary",
  filterSettings = getOption("RMassBank")$filterSettings,
  spectraList = getOption("RMassBank")$spectraList,
  method = "formula"
)

analyzeMsMs.formula(
  msmsPeaks,
  mode = "pH",
  detail = FALSE,
  run = "preliminary",
  filterSettings = getOption("RMassBank")$filterSettings
)

analyzeMsMs.intensity(
  msmsPeaks,
  mode = "pH",
  detail = FALSE,
  run = "preliminary",
  filterSettings = getOption("RMassBank")$filterSettings
)
}
\arguments{
\item{msmsPeaks}{A \code{RmbSpectraSet} object.
    Corresponds to a parent spectrum and children MSMS spectra of one compound (plus some metadata).
 The objects are typically generated with \code{\link{findMsMsHR}}, and populate the \code{@spectrum} slot
 in a \code{msmsWorkspace} (refer to the corresponding
documentation for the precise format specifications).}

\item{mode}{Specifies the processing mode, i.e. which molecule species the
spectra contain. \code{\var{pH}} (positive H) specifies [M+H]+,
\code{\var{pNa}} specifies [M+Na]+, \code{\var{pM}} specifies [M]+,
\code{\var{mH}} and \code{\var{mNa}} specify [M-H]- and [M-Na]-,
respectively. (I apologize for the naming of \code{\var{pH}} which has
absolutely nothing to do with chemical \emph{pH} values.)}

\item{detail}{Whether detailed return information should be provided
(defaults to \code{FALSE}). See below.}

\item{run}{\code{"preliminary"} or \code{"recalibrated"}. In the
\code{preliminary} run, mass tolerance is set to 10 ppm (above m/z 120) and
15 ppm (below m/z 120), the default intensity cutoff is $10^4$ for positive
mode (no default cutoff in negative mode), and the column \code{"mz"} from
the spectra is used as data source.  In the \code{recalibrated} run, the
mass tolerance is set to 5 ppm over the whole mass range, the default cutoff
is 0 and the column \code{"mzRecal"} is used as source for the m/z values.
Defaults to \code{"preliminary"}.}

\item{filterSettings}{Settings for the filter parameters, by default loaded from the RMassBank settings
    set with e.g. \code{\link{loadRmbSettings}}. Must contain:
    \itemize{
        \item \code{ppmHighMass}, allowed ppm deviation before recalibration
            for high mass range
        \item \code{ppmLowMass}, allowed ppm deviation before recalibration
            for low mass range
        \item \code{massRangeDivision}, division point between high and low mass
            range (before recalibration)
        \item \code{ppmFine}, allowed ppm deviation overall after recalibration
        \item \code{prelimCut}, intensity cutoff for peaks in preliminary run
        \item \code{prelimCutRatio}, relative intensity cutoff for peaks in 
            preliminary run, e.g. 0.01 = 1%
        \item \code{fineCut}, intensity cutoff for peaks in second run
        \item \code{fineCutRatio}, relative intensity cutoff for peaks in 
            second run
        \item \code{specOkLimit}, minimum intensity of base peak for spectrum
            to be accepted for processing
        \item \code{dbeMinLimit}, minimum double bond equivalent for accepted
            molecular subformula.
        \item \code{satelliteMzLimit}, for satellite peak filtering 
            (\code{\link{filterPeakSatellites}}: mass window to use for satellite
            removal
        \item \code{satelliteIntLimit}, the relative intensity below which to 
            discard "satellites". (refer to  \code{\link{filterPeakSatellites}}).
}}

\item{spectraList}{The list of MS/MS spectra present in each data block. As also
defined in the settings file.}

\item{method}{Selects which function to actually use for data evaluation. The default
"formula" runs a full analysis via formula assignment to fragment peaks. The
alternative setting "intensity" calls a "mock" implementation which circumvents
formula assignment and filters peaks purely based on intensity cutoffs and the
satellite filtering. (In this case, the ppm and dbe related settings in filterSettings
are ignored.)}
}
\value{
The processed \code{RmbSpectraSet} object.
Added (or filled, respectively, since the slots are present before) data include
\item{list("complete")}{whether all spectra have useful value}
\item{list("empty")}{whether there are no useful spectra}
\item{list("children")}{
		The processed \code{RmbSpectrum2} objects (in a \code{RmbSpectrum2List}).
		\itemize{
			\item \code{ok} if the spectrum was successfully processed with at least one resulting peak
			\item \code{mz}, \code{intensity}: note that mz/int pairs can be duplicated when multiple matches
				are found for one mz value, therefore the two slots are not necessarily unchanged from before
		\item \code{rawOK} (logical) whether the m/z peak passes satellite/low removal
			\item \code{low}, \code{satellite} if \code{TRUE}, the peak failed cutoff (\code{low}) or was removed as \code{satellite}
			\item \code{formula}, \code{mzCalc}, \code{dppm}, \code{dbe} Formula, calculated mass, ppm deviation and dbe assigned to a peak
			\item \code{formulaCount}, \code{dppmBest} Number of formulae matched for this m/z value and ppm deviation of the best match
			\item \code{info} Spectrum identifying information (collision energy, resolution, collision mode) from
				the \code{spectraList} 
			\item All other entries are retained from the original \code{RmbSpectrum2}.
			}
}
}
\description{
Analyzes MSMS spectra of a compound by fitting formulas to each subpeak.
}
\details{
The analysis function uses Rcdk. Note
that in this step, \emph{satellite peaks} are removed by a simple heuristic
rule (refer to the documentation of \code{\link{filterPeakSatellites}} for details.)
}
\section{Functions}{
\itemize{
\item \code{analyzeMsMs.formula()}: Analyze the peaks using formula annotation

\item \code{analyzeMsMs.intensity()}: Analyze the peaks going only by intensity values

}}
\examples{

	\dontrun{analyzed <- analyzeMsMs(spec, "pH", TRUE)}

}
\seealso{
\code{\link{msmsWorkflow}}, \code{\link{filterLowaccResults}},
\code{\link{filterPeakSatellites}}, \code{\link{reanalyzeFailpeaks}}
}
\author{
Michael Stravs
}
