% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lib_enrichment.R
\name{term_enrichment_by_subset}
\alias{term_enrichment_by_subset}
\title{term_enrichment_by_subset}
\usage{
term_enrichment_by_subset(
  groups = NA,
  resources = resources.default,
  q_value_threshold = 0.01,
  verbose = TRUE,
  display_type = "q",
  phred = TRUE,
  ...
)
}
\arguments{
\item{groups}{A list() of genes for enrichment. Each entry in the list() is an input set of genes. Enrichment is performed for each of these entries.}

\item{resources}{character vector for which resources to use in enrichment}

\item{q_value_threshold}{minimum q-value (FDR adjusted p-value) in any group for the term to be included in results}

\item{verbose}{print additional status updates on what the function is doing}

\item{display_type}{Flag for which data type will be returned. One of "q" (default) for q-values, "p" for unadjusted p-values, or "n" for the number of genes overlapping the term.}

\item{phred}{Logical flag (default TRUE) to return the -log10 of p/q values}

\item{...}{Further arguments are passed on to enrichment_symbols()}
}
\value{
Returns a term-by-study matrix of enrichment values (value determined by "display_type")
}
\description{
Run enrichment simultaneously across a group of prioritized gene lists. For example, in a time course dataset, one may have a different list of genes that are differentially expressed at each time point. This function facilitates rapid evaluation of term enrichment across time point comparisons. Alternatively, one may have a different list of differentially expressed genes by drug treatment, environmental condition, ect.
}
\examples{
## Create list of gene sets to evaluate.
##   This example is from a vaccine study where we pre-generated differentially expressed genes.
##   This object will be passed to the groups parameter.
require(RITANdata)
vac1.de.genes <- list(vac1.day0vs31.de.genes, vac1.day0vs56.de.genes)
names(vac1.de.genes) <- c("Day0vs31", "Day0vs56")
print(str(vac1.de.genes))

\dontrun{
## Run term_enrichment_by_subset on the two results.
##   This function usually takes a few seconds to a minute to run.
m <- term_enrichment_by_subset(groups = vac1.de.genes, q_value_threshold = .9)
summary(m)
plot( m, label_size_y = 4, show_values = FALSE )
}

}
